<?php

namespace App\DataTransferObjects;

use Carbon\Carbon;

class CalendarEvent
{
    public function __construct(
        public string $id,
        public string $type, // 'recording', 'publication', 'task'
        public Carbon $date,
        public string $title,
        public ?int $episode_id = null,
        public ?object $episode = null,
        public ?object $task = null,
        public string $color = 'gray',
        public string $icon = 'circle',
        public ?bool $is_done = null,
    ) {}
    
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'date' => $this->date->format('Y-m-d'),
            'title' => $this->title,
            'episode_id' => $this->episode_id,
            'color' => $this->color,
            'icon' => $this->icon,
            'is_done' => $this->is_done,
            'episode' => $this->episode ? [
                'id' => $this->episode->id,
                'title' => $this->episode->title,
                'status' => $this->episode->status,
                'slug' => $this->episode->slug,
            ] : null,
        ];
    }
}
