<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\CalendarService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Carbon\Carbon;

class CalendarController extends Controller
{
    public function __construct(
        private CalendarService $calendarService
    ) {}
    
    /**
     * GET /calendar?year=2026&month=1&view=month
     * GET /calendar?start=2026-01-01&end=2026-01-31&view=week
     */
    public function index(Request $request)
    {
        // Se for requisição JSON (API), retorna JSON
        if ($request->wantsJson() || $request->expectsJson()) {
            $view = $request->get('view', 'month'); // month, week
            $filters = [
                'event_types' => $request->get('event_types', []),
                'statuses' => $request->get('statuses', []),
            ];
            
            if ($view === 'month') {
                $year = (int) $request->get('year', now()->year);
                $month = (int) $request->get('month', now()->month);
                $events = $this->calendarService->getEventsByMonth($year, $month, $filters);
            } else {
                $start = Carbon::parse($request->get('start', now()->startOfWeek()));
                $end = Carbon::parse($request->get('end', now()->endOfWeek()));
                $events = $this->calendarService->getEvents($start, $end, $filters);
            }
            
            return response()->json([
                'data' => [
                    'events' => $events->map(function ($dayEvents) {
                        return $dayEvents->map->toArray();
                    })->toArray(),
                    'view' => $view,
                ],
            ]);
        }
        
        // Retorna view para web
        $statuses = ['pauta', 'gravacao', 'edicao', 'revisao', 'agendado', 'publicado'];
        return view('calendar.index', compact('statuses'));
    }
}
