<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Requests\StorePublicProspectRequest;
use App\Models\Prospect;
use App\Models\Theme;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class PublicProspectController extends Controller
{
    /**
     * Exibe o formulário público de manifestação de interesse
     */
    public function show(): View
    {
        $themes = Theme::orderBy('name')->get();
        return view('public.prospects.form', compact('themes'));
    }

    /**
     * Processa o formulário público de manifestação de interesse
     */
    public function store(StorePublicProspectRequest $request): RedirectResponse
    {
        // Criar prospect automaticamente
        $prospect = Prospect::create([
            'type' => Prospect::TYPE_PERSON, // Formulário sempre cria pessoa
            'name' => $request->name,
            'email' => $request->email,
            'whatsapp' => $request->whatsapp,
            'linkedin_url' => $request->linkedin_url,
            'role_title' => $request->role_title,
            'company_name' => $request->company_name,
            'organization_type' => $request->organization_type,
            'location' => $request->location,
            'what_they_do' => $request->what_they_do,
            'problem_solved' => $request->problem_solved,
            'stage' => $request->stage,
            'expertise_topics' => $request->expertise_topics,
            'story_case' => $request->story_case,
            'ecosystem_request' => $request->ecosystem_request,
            'preferred_format' => $request->preferred_format,
            'preferred_time' => $request->preferred_time,
            'availability_window' => $request->availability_window,
            'consent_given' => $request->has('consent_given'),
            'origin' => Prospect::ORIGIN_INBOUND_FORM,
            'status' => Prospect::STATUS_TO_REVIEW,
            'created_by' => null, // Cadastro público
        ]);

        // Associar temas
        if ($request->has('themes')) {
            $prospect->themes()->attach($request->themes);
        }

        // Enviar email de confirmação (opcional - Sprint 5)
        // Mail::to($prospect->email)->send(new ProspectConfirmation($prospect));

        return redirect()->route('public.prospects.thanks')
            ->with('success', 'Sua manifestação de interesse foi registrada com sucesso!');
    }

    /**
     * Exibe página de agradecimento
     */
    public function thanks(): View
    {
        return view('public.prospects.thanks');
    }
}
