<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Episode;
use App\Models\Theme;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{
    /**
     * Página principal de relatórios
     */
    public function index()
    {
        return view('reports.index');
    }

    /**
     * Top 10 temas mais recorrentes
     */
    public function topThemes(\Illuminate\Http\Request $request)
    {
        $themes = Theme::withCount('episodes')
            ->orderBy('episodes_count', 'desc')
            ->limit(10)
            ->get();

        if ($request->wantsJson() || $request->expectsJson()) {
            return response()->json(['data' => $themes]);
        }

        return response()->json(['data' => $themes]);
    }

    /**
     * Tempo médio entre gravação e publicação
     */
    public function averagePublishTime(\Illuminate\Http\Request $request)
    {
        $avgDays = Episode::whereNotNull('record_date')
            ->whereNotNull('publish_date')
            ->selectRaw('AVG(DATEDIFF(publish_date, record_date)) as avg_days')
            ->value('avg_days');

        $response = [
            'average_days' => $avgDays ? round($avgDays, 2) : null,
            'message' => $avgDays ? "Tempo médio: " . round($avgDays, 2) . " dias" : "Sem dados suficientes",
        ];

        if ($request->wantsJson() || $request->expectsJson()) {
            return response()->json(['data' => $response]);
        }

        return response()->json(['data' => $response]);
    }

    /**
     * Episódios por status
     */
    public function episodesByStatus(\Illuminate\Http\Request $request)
    {
        $statuses = Episode::select('status', DB::raw('count(*) as count'))
            ->groupBy('status')
            ->orderBy('count', 'desc')
            ->get();

        if ($request->wantsJson() || $request->expectsJson()) {
            return response()->json(['data' => $statuses]);
        }

        return response()->json(['data' => $statuses]);
    }

    /**
     * Top 10 convidados mais frequentes
     */
    public function topGuests(\Illuminate\Http\Request $request)
    {
        $guests = \App\Models\Guest::withCount('episodes')
            ->orderBy('episodes_count', 'desc')
            ->limit(10)
            ->get();

        if ($request->wantsJson() || $request->expectsJson()) {
            return response()->json(['data' => $guests]);
        }

        return response()->json(['data' => $guests]);
    }
}
