<?php

namespace App\Http\Requests;

use App\Models\Prospect;
use Illuminate\Foundation\Http\FormRequest;

class StoreProspectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'type' => 'required|in:' . Prospect::TYPE_PERSON . ',' . Prospect::TYPE_COMPANY,
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'whatsapp' => 'nullable|string|max:20',
            'linkedin_url' => 'nullable|url|max:255',
            'website_url' => 'nullable|url|max:255',
            'role_title' => 'nullable|string|max:255',
            'company_name' => 'nullable|string|max:255',
            'organization_type' => 'nullable|in:startup,empresa,governo,academia,osc,hub,outro',
            'sector' => 'nullable|string|max:100',
            'location' => 'nullable|string|max:255',
            'what_they_do' => 'nullable|string|max:500',
            'problem_solved' => 'nullable|string|max:500',
            'stage' => 'nullable|in:ideacao,mvp,tracao,escala,consolidacao',
            'expertise_topics' => 'nullable|string|max:500',
            'story_case' => 'nullable|string|max:500',
            'ecosystem_request' => 'nullable|string|max:500',
            'preferred_format' => 'nullable|in:presencial,online',
            'preferred_time' => 'nullable|in:manha,tarde,noite',
            'availability_window' => 'nullable|string|max:500',
            'consent_given' => 'nullable|boolean',
            'origin' => 'nullable|in:' . implode(',', [
                Prospect::ORIGIN_INBOUND_FORM,
                Prospect::ORIGIN_OUTBOUND_CURATED,
                Prospect::ORIGIN_REFERRAL,
                Prospect::ORIGIN_EVENT,
                Prospect::ORIGIN_OTHER,
            ]),
            'status' => 'nullable|string|max:50',
            'priority' => 'nullable|integer|min:1|max:5',
            'notes' => 'nullable|string',
            'fit_score' => 'nullable|integer|min:1|max:5',
            'impact_potential' => 'nullable|integer|min:1|max:5',
            'timing_score' => 'nullable|integer|min:1|max:5',
            'diversity_flags' => 'nullable|array',
            'rejection_reason' => 'nullable|string',
            'preferred_slots' => 'nullable|string',
            'scheduled_at' => 'nullable|date',
            'meeting_link' => 'nullable|url|max:255',
            'themes' => 'nullable|array',
            'themes.*' => 'exists:themes,id',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'O nome é obrigatório.',
            'email.required' => 'O e-mail é obrigatório.',
            'email.email' => 'Por favor, informe um e-mail válido.',
            'type.required' => 'O tipo é obrigatório.',
            'type.in' => 'O tipo deve ser pessoa ou empresa.',
            'priority.min' => 'A prioridade deve ser entre 1 e 5.',
            'priority.max' => 'A prioridade deve ser entre 1 e 5.',
            'fit_score.min' => 'O score de fit deve ser entre 1 e 5.',
            'fit_score.max' => 'O score de fit deve ser entre 1 e 5.',
            'impact_potential.min' => 'O potencial de impacto deve ser entre 1 e 5.',
            'impact_potential.max' => 'O potencial de impacto deve ser entre 1 e 5.',
            'timing_score.min' => 'O score de timing deve ser entre 1 e 5.',
            'timing_score.max' => 'O score de timing deve ser entre 1 e 5.',
        ];
    }
}
