<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePublicProspectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // Formulário público, sem autenticação
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            // Bloco A - Identificação
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'whatsapp' => 'nullable|string|max:20',
            'linkedin_url' => 'nullable|url|max:255',
            
            // Bloco B - Perfil
            'organization_type' => 'required|in:startup,empresa,governo,academia,osc,hub,outro',
            'company_name' => 'required|string|max:255',
            'role_title' => 'required|string|max:255',
            'location' => 'required|string|max:255',
            
            // Bloco C - Sobre a Iniciativa
            'what_they_do' => 'required|string|max:500',
            'problem_solved' => 'required|string|max:500',
            'stage' => 'required|in:ideacao,mvp,tracao,escala,consolidacao',
            
            // Bloco D - Pauta e Valor
            'themes' => 'required|array|min:1',
            'themes.*' => 'exists:themes,id',
            'expertise_topics' => 'required|string|max:500',
            'story_case' => 'required|string|max:500',
            'ecosystem_request' => 'nullable|string|max:500',
            
            // Bloco E - Disponibilidade
            'preferred_format' => 'required|in:presencial,online',
            'preferred_time' => 'required|in:manha,tarde,noite',
            'availability_window' => 'nullable|string|max:500',
            'consent_given' => 'required|accepted',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'O nome completo é obrigatório.',
            'email.required' => 'O e-mail é obrigatório.',
            'email.email' => 'Por favor, informe um e-mail válido.',
            'organization_type.required' => 'Selecione o tipo de organização.',
            'company_name.required' => 'O nome da organização é obrigatório.',
            'role_title.required' => 'O cargo/função é obrigatório.',
            'location.required' => 'A cidade/estado é obrigatória.',
            'what_they_do.required' => 'Descreva o que vocês fazem.',
            'problem_solved.required' => 'Descreva qual problema vocês resolvem.',
            'stage.required' => 'Selecione o estágio atual.',
            'themes.required' => 'Selecione pelo menos um tema.',
            'themes.min' => 'Selecione pelo menos um tema.',
            'expertise_topics.required' => 'Informe os 3 tópicos que você domina.',
            'story_case.required' => 'Compartilhe uma história/caso real.',
            'preferred_format.required' => 'Selecione o formato preferido.',
            'preferred_time.required' => 'Selecione o melhor período.',
            'consent_given.required' => 'Você precisa autorizar o contato.',
            'consent_given.accepted' => 'Você precisa autorizar o contato.',
        ];
    }
}
