<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreThemeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $theme = $this->route('theme');
        $themeId = $theme instanceof \App\Models\Theme ? $theme->id : $theme;
        
        return [
            'name' => ['required', 'string', 'max:255', 'unique:themes,name,' . $themeId],
            'description' => ['nullable', 'string'],
        ];
    }
}
