<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateEpisodeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // Autenticação já é verificada pelo middleware
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $episode = $this->route('episode');
        $episodeId = $episode instanceof \App\Models\Episode ? $episode->id : $episode;
        
        return [
            'title' => ['required', 'string', 'max:255'],
            'slug' => ['required', 'string', 'max:255', 'unique:episodes,slug,' . $episodeId],
            'record_date' => ['nullable', 'date'],
            'publish_date' => ['nullable', 'date'],
            'status' => ['required', 'string', 'in:pauta,gravacao,edicao,revisao,agendado,publicado'],
            'description' => ['nullable', 'string'],
            'tags' => ['nullable', 'string', 'max:500'],
            'youtube_url' => ['nullable', 'url', 'max:500'],
            'spotify_url' => ['nullable', 'url', 'max:500'],
            'guests' => ['nullable', 'array'],
            'guests.*' => ['exists:guests,id'],
            'themes' => ['nullable', 'array'],
            'themes.*' => ['exists:themes,id'],
        ];
    }
}
