<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EpisodeAsset extends Model
{
    protected $fillable = [
        'episode_id',
        'asset_type',
        'label',
        'url',
    ];

    /**
     * Episódio ao qual este asset pertence
     */
    public function episode(): BelongsTo
    {
        return $this->belongsTo(Episode::class);
    }
}
