<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EpisodeMetric extends Model
{
    protected $fillable = [
        'episode_id',
        'views',
        'plays',
        'engagement_rate',
        'avg_time_to_publish_days',
        'metric_date',
    ];

    protected $casts = [
        'engagement_rate' => 'decimal:2',
        'metric_date' => 'date',
    ];

    /**
     * Episódio ao qual esta métrica pertence
     */
    public function episode(): BelongsTo
    {
        return $this->belongsTo(Episode::class);
    }
}
