<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EpisodeNote extends Model
{
    protected $fillable = [
        'episode_id',
        'note',
        'created_by',
    ];

    /**
     * Episódio ao qual esta nota pertence
     */
    public function episode(): BelongsTo
    {
        return $this->belongsTo(Episode::class);
    }

    /**
     * Usuário que criou a nota
     */
    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
