<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Guest extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'role_title',
        'organization',
        'organization_id',
        'prospect_id',
        'bio_short',
        'linkedin_url',
        'website_url',
    ];

    /**
     * Organização à qual este convidado pertence
     */
    public function organization(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Organization::class);
    }

    /**
     * Prospect que originou este convidado
     */
    public function prospect(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Prospect::class);
    }

    /**
     * Episódios em que este convidado participou
     */
    public function episodes(): BelongsToMany
    {
        return $this->belongsToMany(Episode::class, 'episode_guests')
            ->withPivot('guest_role')
            ->withTimestamps();
    }
}
