<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Organization extends Model
{
    protected $fillable = [
        'name',
        'type',
        'description',
        'website_url',
        'linkedin_url',
    ];

    /**
     * Convidados vinculados a esta organização
     */
    public function guests(): HasMany
    {
        return $this->hasMany(Guest::class);
    }
}
