<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Theme extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'description',
    ];

    /**
     * Episódios que abordam este tema
     */
    public function episodes(): BelongsToMany
    {
        return $this->belongsToMany(Episode::class, 'episode_themes')
            ->withTimestamps();
    }

    /**
     * Prospects interessados neste tema
     */
    public function prospects(): BelongsToMany
    {
        return $this->belongsToMany(Prospect::class, 'prospect_themes')
            ->withTimestamps();
    }
}
