<?php

namespace Database\Factories;

use App\Models\Episode;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Episode>
 */
class EpisodeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $title = fake()->sentence(3);
        $slug = \Illuminate\Support\Str::slug($title);
        
        return [
            'title' => $title,
            'slug' => $slug,
            'record_date' => fake()->optional()->date(),
            'publish_date' => fake()->optional()->date(),
            'status' => fake()->randomElement(['pauta', 'gravacao', 'edicao', 'revisao', 'agendado', 'publicado']),
            'description' => fake()->optional()->paragraph(),
            'tags' => fake()->optional()->words(5, true),
            'youtube_url' => fake()->optional()->url(),
            'spotify_url' => fake()->optional()->url(),
            'created_by' => User::factory(),
        ];
    }
}
