<?php

namespace Database\Factories;

use App\Models\Guest;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Guest>
 */
class GuestFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->name(),
            'role_title' => fake()->optional()->jobTitle(),
            'organization' => fake()->optional()->company(),
            'organization_id' => null,
            'bio_short' => fake()->optional()->paragraph(),
            'linkedin_url' => fake()->optional()->url(),
            'website_url' => fake()->optional()->url(),
        ];
    }
}
