<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('episodes', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->date('record_date')->nullable()->comment('Data de gravação');
            $table->date('publish_date')->nullable()->comment('Data de publicação');
            $table->string('status', 50)->default('pauta')->comment('pauta/gravacao/edicao/revisao/agendado/publicado');
            $table->text('description')->nullable();
            $table->string('tags')->nullable()->comment('Tags simples no MVP');
            $table->string('youtube_url')->nullable();
            $table->string('spotify_url')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('episodes');
    }
};
