<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('episode_metrics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('episode_id')->constrained('episodes')->cascadeOnDelete();
            $table->unsignedBigInteger('views')->default(0);
            $table->unsignedBigInteger('plays')->default(0);
            $table->decimal('engagement_rate', 5, 2)->nullable()->comment('Taxa de engajamento em %');
            $table->integer('avg_time_to_publish_days')->nullable()->comment('Tempo médio até publicação em dias');
            $table->date('metric_date')->nullable()->comment('Data da métrica (para histórico)');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('episode_metrics');
    }
};
