<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('episodes', function (Blueprint $table) {
            $table->index('record_date');
            $table->index('publish_date');
        });
        
        Schema::table('episode_tasks', function (Blueprint $table) {
            $table->index('due_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('episodes', function (Blueprint $table) {
            $table->dropIndex(['record_date']);
            $table->dropIndex(['publish_date']);
        });
        
        Schema::table('episode_tasks', function (Blueprint $table) {
            $table->dropIndex(['due_date']);
        });
    }
};
