<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('episodes', function (Blueprint $table) {
            $table->index('status');
            $table->index('created_at');
        });

        Schema::table('episode_guests', function (Blueprint $table) {
            $table->index('guest_id');
        });

        Schema::table('episode_themes', function (Blueprint $table) {
            $table->index('theme_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('episodes', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['created_at']);
        });

        Schema::table('episode_guests', function (Blueprint $table) {
            $table->dropIndex(['guest_id']);
        });

        Schema::table('episode_themes', function (Blueprint $table) {
            $table->dropIndex(['theme_id']);
        });
    }
};
