<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('console_logs', function (Blueprint $table) {
            $table->id();
            $table->string('type', 50); // console.error, console.warn, unhandled_error, unhandled_rejection
            $table->text('message');
            $table->text('data')->nullable(); // Stack trace ou dados adicionais
            $table->string('severity', 20)->default('info'); // error, warning, info
            $table->text('context')->nullable(); // JSON com contexto (URL, user agent, etc.)
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->timestamps();

            // Índices para consultas
            $table->index('type');
            $table->index('severity');
            $table->index('created_at');
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('console_logs');
    }
};
