<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('console_logs', function (Blueprint $table) {
            $table->boolean('is_resolved')->default(false)->after('user_id');
            $table->timestamp('resolved_at')->nullable()->after('is_resolved');
            $table->foreignId('resolved_by')->nullable()->after('resolved_at')->constrained('users')->nullOnDelete();
            $table->text('resolution_notes')->nullable()->after('resolved_by');
            
            // Índice para consultas de logs não resolvidos
            $table->index('is_resolved');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('console_logs', function (Blueprint $table) {
            $table->dropForeign(['resolved_by']);
            $table->dropIndex(['is_resolved']);
            $table->dropColumn(['is_resolved', 'resolved_at', 'resolved_by', 'resolution_notes']);
        });
    }
};
