<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prospects', function (Blueprint $table) {
            $table->id();
            
            // Identificação (formulário público)
            $table->enum('type', ['person', 'company'])->default('person');
            $table->string('name');
            $table->string('email');
            $table->string('whatsapp', 20)->nullable();
            $table->string('linkedin_url')->nullable();
            $table->string('website_url')->nullable();
            
            // Perfil (formulário público)
            $table->string('role_title')->nullable()->comment('Cargo/atuação (se person)');
            $table->string('company_name')->nullable()->comment('Empresa (se person)');
            $table->enum('organization_type', ['startup', 'empresa', 'governo', 'academia', 'osc', 'hub', 'outro'])->nullable();
            $table->string('sector', 100)->nullable()->comment('Categoria/setor');
            $table->string('location')->nullable()->comment('Cidade/Estado');
            
            // Sobre a Iniciativa (formulário público)
            $table->text('what_they_do')->nullable()->comment('Em uma frase: o que fazem?');
            $table->text('problem_solved')->nullable()->comment('Qual problema resolvem e para quem?');
            $table->enum('stage', ['ideacao', 'mvp', 'tracao', 'escala', 'consolidacao'])->nullable();
            
            // Pauta e Valor (formulário público)
            $table->text('expertise_topics')->nullable()->comment('3 tópicos que domina');
            $table->text('story_case')->nullable()->comment('História/caso real para compartilhar');
            $table->text('ecosystem_request')->nullable()->comment('Pedido para o ecossistema');
            
            // Disponibilidade (formulário público)
            $table->enum('preferred_format', ['presencial', 'online'])->nullable();
            $table->enum('preferred_time', ['manha', 'tarde', 'noite'])->nullable();
            $table->text('availability_window')->nullable()->comment('Janela de disponibilidade');
            $table->boolean('consent_given')->default(false)->comment('Autorização de contato');
            
            // Curadoria (mínimo para Sprint 1)
            $table->enum('origin', ['inbound_form', 'outbound_curated', 'referral', 'event', 'other'])->default('inbound_form');
            $table->string('status', 50)->default('to_review')
                ->comment('to_review, approved, invited, in_conversation, scheduled, confirmed, recorded, published, follow_up, rejected, archived');
            
            // Campos de curadoria (serão expandidos no Sprint 2)
            $table->tinyInteger('priority')->nullable()->comment('1-5');
            $table->text('notes')->nullable()->comment('Justificativa editorial');
            $table->tinyInteger('fit_score')->nullable()->comment('1-5');
            $table->tinyInteger('impact_potential')->nullable()->comment('1-5');
            $table->tinyInteger('timing_score')->nullable()->comment('1-5');
            $table->tinyInteger('total_score')->nullable()->comment('fit + impact + timing (3-15)');
            $table->json('diversity_flags')->nullable()->comment('Flags de diversidade');
            $table->text('rejection_reason')->nullable()->comment('Motivo da rejeição (se rejected)');
            
            // Agendamento (será usado no Sprint 4)
            $table->text('preferred_slots')->nullable()->comment('Janelas preferidas');
            $table->dateTime('scheduled_at')->nullable()->comment('Data/hora agendada');
            $table->string('meeting_link')->nullable()->comment('Link da reunião');
            
            // Relacionamentos
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete()
                ->comment('Usuário que cadastrou (NULL se formulário público)');
            $table->timestamps();

            // Índices
            $table->index('status');
            $table->index('type');
            $table->index('origin');
            $table->index('priority');
            $table->index('total_score');
            $table->index('email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prospects');
    }
};
