<?php

namespace Database\Seeders;

use App\Models\Theme;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ThemeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $themes = [
            'GovTech',
            'Smart Cities',
            'Ecossistemas de Inovação',
            'Empreendedorismo',
            'Tecnologia & Sociedade',
            'Inovação Pública',
            'Transformação Digital',
            'Sustentabilidade',
            'Educação & Tecnologia',
            'Economia Criativa',
        ];

        foreach ($themes as $themeName) {
            Theme::firstOrCreate(
                ['name' => $themeName],
                ['description' => null]
            );
        }
    }
}
