<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Criar usuário admin padrão
        User::firstOrCreate(
            ['email' => 'admin@empatheia.me'],
            [
                'name' => 'Administrador',
                'password' => Hash::make('admin123'),
                'role' => 'admin',
            ]
        );

        // Criar usuário editor padrão (opcional)
        User::firstOrCreate(
            ['email' => 'editor@gestor-editorial.com'],
            [
                'name' => 'Editor',
                'password' => Hash::make('editor123'),
                'role' => 'editor',
            ]
        );
    }
}
