# 📸 Banners do Formulário

Esta pasta armazena os banners que aparecem no topo do formulário de manifestação de interesse.

## 📐 Tamanhos Recomendados

### Opção 1: Banner Responsivo Único (Recomendado)
**Tamanho:** `1920 x 600px`
- **Proporção:** 16:5 (3.2:1)
- **Formato:** JPG, PNG ou WebP
- **Peso máximo:** 300KB (otimizado)
- **Uso:** Uma única imagem que se adapta a todos os tamanhos de tela

### Opção 2: Múltiplos Tamanhos (Otimizado)
Para melhor performance, você pode criar 3 versões:

#### Desktop
- **Tamanho:** `1920 x 600px`
- **Proporção:** 16:5
- **Peso:** ~200-300KB

#### Tablet
- **Tamanho:** `1200 x 400px`
- **Proporção:** 3:1
- **Peso:** ~150-200KB

#### Mobile
- **Tamanho:** `800 x 300px`
- **Proporção:** 8:3
- **Peso:** ~100-150KB

## 🎨 Especificações Técnicas

### Formato de Arquivo
- **Recomendado:** WebP (melhor compressão)
- **Alternativas:** JPG (fotos) ou PNG (com transparência)
- **Evitar:** GIF (muito pesado)

### Qualidade
- **JPG:** 80-85% de qualidade
- **WebP:** 80-90% de qualidade
- **PNG:** Use apenas se precisar de transparência

### Otimização
- Comprima as imagens antes de fazer upload
- Use ferramentas como:
  - [TinyPNG](https://tinypng.com/)
  - [Squoosh](https://squoosh.app/)
  - [ImageOptim](https://imageoptim.com/)

## 📱 Breakpoints de Exibição

O banner será exibido com as seguintes larguras:

- **Mobile:** `< 640px` - Largura: 100% (padding lateral)
- **Tablet:** `640px - 1024px` - Largura: 100% (padding lateral)
- **Desktop:** `> 1024px` - Largura: 100% (padding lateral)

## 🎯 Área Segura

Mantenha conteúdo importante dentro de:
- **Desktop:** Centro 1400px
- **Tablet:** Centro 900px
- **Mobile:** Centro 600px

Isso garante que textos e elementos importantes não sejam cortados.

## 📝 Convenção de Nomenclatura

Sugestão de nomes:
- `banner-formulario.jpg` (banner único)
- `banner-formulario-desktop.jpg` (versão desktop)
- `banner-formulario-tablet.jpg` (versão tablet)
- `banner-formulario-mobile.jpg` (versão mobile)

## 🔄 Atualização

Para atualizar o banner:
1. Substitua o arquivo na pasta `public/images/banners/`
2. Mantenha o mesmo nome do arquivo (ou atualize a view)
3. Limpe o cache: `php artisan view:clear`

## ⚠️ Importante

- **Não** coloque informações críticas nas bordas (podem ser cortadas)
- **Mantenha** textos legíveis em todos os tamanhos
- **Teste** em diferentes dispositivos antes de publicar
- **Otimize** sempre as imagens para web
