import './bootstrap';

import Alpine from 'alpinejs';
import { initFlowbite } from 'flowbite';
import { apiFetch } from './api';
import { initToast, showToast } from './toast';
import { initConsoleTracker, setDebugMode, stopConsoleTracker } from './console-tracker';
import { calendarEditorial } from './calendar';
import './form-helpers';

window.Alpine = Alpine;
window.apiFetch = apiFetch;
window.showToast = showToast;

// Expõe funções do console tracker para debug
window.initConsoleTracker = initConsoleTracker;
window.setConsoleTrackerDebug = setDebugMode;
window.stopConsoleTracker = stopConsoleTracker;

// Expõe função do calendário para Alpine.js (deve estar disponível antes do Alpine.start())
window.calendarEditorial = calendarEditorial;

// Inicializa toast, Flowbite e console tracker quando DOM estiver pronto
const initApp = () => {
    initToast();
    initFlowbite();
    // Inicializa console tracker com otimizações de performance
    // Em produção, pode desabilitar com: { enabled: false }
    initConsoleTracker({
        debug: false,
        bufferSize: 20, // Envia em batches de 20 logs
        flushInterval: 60000, // Flush a cada 60 segundos
        maxLogsPerMinute: 30, // Limite de 30 logs por minuto
        maxLogsPerSession: 200, // Máximo de 200 logs por sessão
        debounceDelay: 5000, // Aguarda 5s antes de enviar
    });
};

if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', () => {
        initApp();
    });
} else {
    initApp();
}

// Inicia Alpine.js após garantir que todos os componentes estão disponíveis
Alpine.start();
