<x-app-layout>
    <x-slot name="page-title">Calendário Editorial</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Calendário</li>
    </x-slot>

    <div class="space-y-6" x-data="calendarEditorial()">
        <!-- Header com Navegação -->
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                <button 
                    @click="previousMonth()"
                    class="p-2 text-gray-600 hover:bg-gray-100 rounded-lg transition-colors"
                    title="Mês anterior"
                >
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </button>
                <h1 class="text-2xl font-bold text-gray-900" x-text="currentMonthLabel"></h1>
                <button 
                    @click="nextMonth()"
                    class="p-2 text-gray-600 hover:bg-gray-100 rounded-lg transition-colors"
                    title="Próximo mês"
                >
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </button>
                <button 
                    @click="goToToday()"
                    class="ml-4 px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                >
                    Hoje
                </button>
            </div>
        </div>

        <!-- Filtros -->
        <x-card>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Filtro Tipo de Evento -->
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900">Tipo de Evento</label>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input 
                                type="checkbox" 
                                x-model="filters.event_types"
                                value="recording"
                                @change="loadEvents()"
                                class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500"
                            >
                            <span class="ml-2 text-sm text-gray-700">🎙 Gravação</span>
                        </label>
                        <label class="flex items-center">
                            <input 
                                type="checkbox" 
                                x-model="filters.event_types"
                                value="publication"
                                @change="loadEvents()"
                                class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500"
                            >
                            <span class="ml-2 text-sm text-gray-700">📢 Publicação</span>
                        </label>
                        <label class="flex items-center">
                            <input 
                                type="checkbox" 
                                x-model="filters.event_types"
                                value="task"
                                @change="loadEvents()"
                                class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500"
                            >
                            <span class="ml-2 text-sm text-gray-700">📝 Tarefa</span>
                        </label>
                    </div>
                </div>

                <!-- Filtro Status -->
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900">Status do Episódio</label>
                    <select 
                        x-model="filters.statuses"
                        @change="loadEvents()"
                        multiple
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5"
                        size="4"
                    >
                        @foreach($statuses as $status)
                            <option value="{{ $status }}">{{ ucfirst($status) }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Botão Limpar -->
                <div class="flex items-end">
                    <button 
                        @click="clearFilters()"
                        class="w-full px-4 py-2.5 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                    >
                        Limpar Filtros
                    </button>
                </div>
            </div>
        </x-card>

        <!-- Loading State -->
        <div x-show="loading" class="text-center py-12">
            <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-blue-600"></div>
            <p class="mt-2 text-gray-600">Carregando calendário...</p>
        </div>

        <!-- Calendário -->
        <x-card :padding="false" x-show="!loading" style="display: none;">
            <div class="overflow-x-auto">
                <!-- Dias da Semana -->
                <div class="grid grid-cols-7 border-b border-gray-200">
                    <template x-for="day in weekDays" :key="day">
                        <div class="p-3 text-center text-sm font-medium text-gray-700 bg-gray-50">
                            <span x-text="day"></span>
                        </div>
                    </template>
                </div>

                <!-- Grid do Calendário -->
                <div class="grid grid-cols-7">
                    <template x-for="(week, weekIndex) in calendarWeeks" :key="weekIndex">
                        <template x-for="(day, dayIndex) in week" :key="dayIndex">
                            <div 
                                class="min-h-[120px] border-r border-b border-gray-200 p-2"
                                :class="{
                                    'bg-gray-50': !day.isCurrentMonth,
                                    'bg-white': day.isCurrentMonth,
                                    'bg-blue-50': day.isToday
                                }"
                            >
                                <!-- Número do Dia -->
                                <div class="flex items-center justify-between mb-1">
                                    <span 
                                        class="text-sm font-medium"
                                        :class="{
                                            'text-gray-400': !day.isCurrentMonth,
                                            'text-gray-900': day.isCurrentMonth && !day.isToday,
                                            'text-blue-600 font-bold': day.isToday
                                        }"
                                        x-text="day.day"
                                    ></span>
                                </div>

                                <!-- Eventos do Dia -->
                                <div class="space-y-1">
                                    <template x-for="(event, eventIndex) in getEventsForDay(day.date)" :key="event.id">
                                        <button
                                            @click="openEventModal(event)"
                                            class="w-full text-left px-2 py-1 text-xs rounded truncate transition-colors"
                                            :class="getEventColorClass(event)"
                                            :title="event.title"
                                        >
                                            <span x-text="getEventIcon(event)"></span>
                                            <span class="ml-1" x-text="event.title"></span>
                                        </button>
                                    </template>
                                    <template x-if="getEventsForDay(day.date).length > 2">
                                        <button
                                            @click="openDayModal(day.date)"
                                            class="w-full text-left px-2 py-1 text-xs text-gray-600 hover:bg-gray-100 rounded"
                                        >
                                            +<span x-text="getEventsForDay(day.date).length - 2"></span> mais
                                        </button>
                                    </template>
                                </div>
                            </div>
                        </template>
                    </template>
                </div>
            </div>
        </x-card>
    </div>

    <!-- Modal de Evento -->
    <div 
        x-show="showEventModal"
        @click.away="showEventModal = false"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="fixed inset-0 bg-gray-900 bg-opacity-50 z-50 flex items-center justify-center p-4"
        style="display: none;"
    >
        <div 
            @click.stop
            class="bg-white rounded-lg shadow-xl max-w-md w-full p-6"
        >
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-900" x-text="selectedEvent?.title"></h3>
                <button 
                    @click="showEventModal = false"
                    class="text-gray-400 hover:text-gray-600"
                >
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
            
            <div class="space-y-3">
                <template x-if="selectedEvent?.episode">
                    <div>
                        <p class="text-sm text-gray-600">Episódio:</p>
                        <p class="font-medium text-gray-900" x-text="selectedEvent.episode.title"></p>
                        <div class="mt-2">
                            <span x-html="getBadgeStatus(selectedEvent.episode.status)"></span>
                        </div>
                    </div>
                </template>
                
                <div>
                    <p class="text-sm text-gray-600">Data:</p>
                    <p class="font-medium text-gray-900" x-text="formatDate(selectedEvent?.date)"></p>
                </div>
            </div>
            
            <div class="mt-6 flex justify-end gap-2">
                <template x-if="selectedEvent?.episode_id">
                    <a 
                        :href="`/episodes/${selectedEvent.episode_id}`"
                        class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700"
                    >
                        Abrir Episódio
                    </a>
                </template>
                <button 
                    @click="showEventModal = false"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                >
                    Fechar
                </button>
            </div>
        </div>
    </div>
</x-app-layout>

