<x-app-layout>
    <x-slot name="page-title">Teste de Componentes</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Teste de Componentes</li>
    </x-slot>

    <div class="space-y-8">
        <!-- Buttons -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Buttons</h2>
            <x-card>
                <div class="space-y-4">
                    <div class="flex flex-wrap gap-4">
                        <x-button variant="primary">Primary</x-button>
                        <x-button variant="secondary">Secondary</x-button>
                        <x-button variant="danger">Danger</x-button>
                        <x-button variant="ghost">Ghost</x-button>
                    </div>
                    <div class="flex flex-wrap gap-4">
                        <x-button variant="primary" size="sm">Small</x-button>
                        <x-button variant="primary" size="md">Medium</x-button>
                        <x-button variant="primary" size="lg">Large</x-button>
                    </div>
                </div>
            </x-card>
        </section>

        <!-- Badges -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Badges</h2>
            <x-card>
                <div class="flex flex-wrap gap-4">
                    <x-badge variant="default">Default</x-badge>
                    <x-badge variant="success">Success</x-badge>
                    <x-badge variant="warning">Warning</x-badge>
                    <x-badge variant="danger">Danger</x-badge>
                    <x-badge variant="info">Info</x-badge>
                </div>
                <div class="flex flex-wrap gap-4 mt-4">
                    <x-badge variant="default" size="sm">Small</x-badge>
                    <x-badge variant="default" size="md">Medium</x-badge>
                </div>
            </x-card>
        </section>

        <!-- Badge Status -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Badge Status (Episódios)</h2>
            <x-card>
                <div class="flex flex-wrap gap-4">
                    <x-badge-status status="pauta" />
                    <x-badge-status status="gravacao" />
                    <x-badge-status status="edicao" />
                    <x-badge-status status="revisao" />
                    <x-badge-status status="agendado" />
                    <x-badge-status status="publicado" />
                </div>
                <div class="flex flex-wrap gap-4 mt-4">
                    <x-badge-status status="pauta" size="sm" />
                    <x-badge-status status="publicado" size="sm" />
                </div>
            </x-card>
        </section>

        <!-- Cards -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Cards</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <x-card>
                    <h3 class="text-lg font-semibold mb-2">Card com Padding</h3>
                    <p class="text-gray-600">Este card tem padding padrão.</p>
                </x-card>
                <x-card :padding="false">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold mb-2">Card sem Padding</h3>
                        <p class="text-gray-600">Este card tem padding desabilitado.</p>
                    </div>
                </x-card>
            </div>
        </section>

        <!-- Empty State -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Empty State</h2>
            <x-card>
                <x-empty-state 
                    title="Nenhum episódio encontrado"
                    description="Você ainda não criou nenhum episódio. Comece criando o primeiro!"
                    action-label="Criar Episódio"
                    action-url="{{ route('episodes.create') }}"
                />
            </x-card>
        </section>

        <!-- Form Components -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Form Components</h2>
            <x-card>
                <form class="space-y-6" id="test-form">
                    <!-- Input -->
                    <x-form.input 
                        name="test_input"
                        label="Input de Texto"
                        placeholder="Digite algo..."
                        required
                    />

                    <!-- Textarea -->
                    <x-form.textarea 
                        name="test_textarea"
                        label="Textarea"
                        placeholder="Digite uma descrição..."
                        rows="4"
                    />

                    <!-- Select -->
                    <x-form.select 
                        name="test_select"
                        label="Select"
                        :options="[
                            '1' => 'Opção 1',
                            '2' => 'Opção 2',
                            '3' => 'Opção 3',
                        ]"
                        placeholder="Selecione uma opção"
                    />

                    <!-- MultiSelect -->
                    <x-form.multiselect 
                        name="test_multiselect"
                        label="MultiSelect"
                        :options="[
                            ['id' => 1, 'name' => 'Convidado 1'],
                            ['id' => 2, 'name' => 'Convidado 2'],
                            ['id' => 3, 'name' => 'Convidado 3'],
                            ['id' => 4, 'name' => 'Convidado 4'],
                            ['id' => 5, 'name' => 'Convidado 5'],
                        ]"
                        placeholder="Selecione convidados"
                    />

                    <!-- MultiSelect com Busca Remota (simulado) -->
                    <x-form.multiselect 
                        name="test_multiselect_remote"
                        label="MultiSelect com Busca Remota (simulado)"
                        :options="[]"
                        placeholder="Digite para buscar..."
                        search-url="/api/guests"
                        search-param="q"
                    />

                    <div class="flex gap-4">
                        <x-button type="submit" variant="primary">Enviar Formulário</x-button>
                        <x-button type="button" variant="secondary" onclick="clearFormErrors(document.getElementById('test-form'))">
                            Limpar Erros
                        </x-button>
                    </div>
                </form>
            </x-card>
        </section>

        <!-- Modal Confirm -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Modal Confirm</h2>
            <x-card>
                <div class="flex flex-wrap gap-4">
                    <button 
                        type="button"
                        class="inline-flex items-center justify-center font-medium rounded-lg focus:outline-none focus:ring-4 transition-colors text-white bg-blue-600 hover:bg-blue-700 focus:ring-blue-300 px-4 py-2 text-sm"
                        data-modal-target="confirm-modal-primary"
                        data-modal-toggle="confirm-modal-primary"
                    >
                        Abrir Modal Primary
                    </button>
                    <button 
                        type="button"
                        class="inline-flex items-center justify-center font-medium rounded-lg focus:outline-none focus:ring-4 transition-colors text-white bg-red-600 hover:bg-red-700 focus:ring-red-300 px-4 py-2 text-sm"
                        data-modal-target="confirm-modal-danger"
                        data-modal-toggle="confirm-modal-danger"
                    >
                        Abrir Modal Danger
                    </button>
                </div>
            </x-card>
        </section>

        <!-- Toast Test -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Toast Notifications</h2>
            <x-card>
                <div class="flex flex-wrap gap-4">
                    <x-button variant="primary" onclick="window.showToast('Operação realizada com sucesso!', 'success')">
                        Toast Success
                    </x-button>
                    <x-button variant="danger" onclick="window.showToast('Erro ao processar!', 'error')">
                        Toast Error
                    </x-button>
                    <x-button variant="secondary" onclick="window.showToast('Atenção: Verifique os dados', 'warning')">
                        Toast Warning
                    </x-button>
                    <x-button variant="ghost" onclick="window.showToast('Informação importante', 'info')">
                        Toast Info
                    </x-button>
                </div>
            </x-card>
        </section>

        <!-- API Fetch Test -->
        <section>
            <h2 class="text-2xl font-bold text-gray-900 mb-4">API Fetch Test</h2>
            <x-card>
                <div class="space-y-4">
                    <x-button 
                        variant="primary"
                        onclick="testApiFetch()"
                    >
                        Testar API Fetch (GET /api/episodes)
                    </x-button>
                    <div id="api-result" class="mt-4 p-4 bg-gray-100 rounded-lg hidden">
                        <pre class="text-sm" id="api-result-content"></pre>
                    </div>
                </div>
            </x-card>
        </section>
    </div>

    <!-- Modals -->
    <x-modal-confirm 
        id="confirm-modal-primary"
        title="Confirmar Ação"
        message="Tem certeza que deseja realizar esta ação?"
        confirm-label="Confirmar"
        cancel-label="Cancelar"
        variant="primary"
    />

    <x-modal-confirm 
        id="confirm-modal-danger"
        title="Confirmar Exclusão"
        message="Esta ação não pode ser desfeita. Tem certeza que deseja excluir?"
        confirm-label="Excluir"
        cancel-label="Cancelar"
        variant="danger"
    />

    @push('scripts')
    <script>
        // Teste de API Fetch
        async function testApiFetch() {
            const resultDiv = document.getElementById('api-result');
            const resultContent = document.getElementById('api-result-content');
            
            resultDiv.classList.add('hidden');
            resultContent.textContent = 'Carregando...';
            
            try {
                const response = await window.apiFetch('/api/episodes');
                resultContent.textContent = JSON.stringify(response, null, 2);
                resultDiv.classList.remove('hidden');
                window.showToast('API Fetch executado com sucesso!', 'success');
            } catch (error) {
                resultContent.textContent = 'Erro: ' + error.message;
                resultDiv.classList.remove('hidden');
                window.showToast('Erro ao executar API Fetch', 'error');
            }
        }

        // Intercepta submit do formulário para teste
        document.getElementById('test-form')?.addEventListener('submit', function(e) {
            e.preventDefault();
            window.showToast('Formulário enviado (simulado)', 'success');
        });
    </script>
    @endpush
</x-app-layout>
