@props([
    'status', // pauta, gravacao, edicao, revisao, agendado, publicado
    'size' => 'md', // sm, md
])

@php
    // Mapeamento de status para labels e cores
    $statusMap = [
        'pauta' => ['label' => 'Pauta', 'variant' => 'default'],
        'gravacao' => ['label' => 'Gravação', 'variant' => 'info'],
        'edicao' => ['label' => 'Edição', 'variant' => 'warning'],
        'revisao' => ['label' => 'Revisão', 'variant' => 'warning'],
        'agendado' => ['label' => 'Agendado', 'variant' => 'info'],
        'publicado' => ['label' => 'Publicado', 'variant' => 'success'],
    ];
    
    $config = $statusMap[$status] ?? $statusMap['pauta'];
    $label = $config['label'];
    $variant = $config['variant'];
@endphp

<x-badge :variant="$variant" :size="$size" {{ $attributes }}>
    {{ $label }}
</x-badge>
