@props([
    'name',
    'label' => null,
    'value' => null,
    'placeholder' => null,
    'required' => false,
    'rows' => 4,
    'error' => null,
])

@php
    $hasError = $error || ($errors->has($name) ?? false);
    $errorMessage = $error ?? ($errors->first($name) ?? null);
    $inputId = $attributes->get('id', $name);
    $inputValue = old($name, $value ?? '');
@endphp

<div class="mb-4">
    @if($label)
        <label for="{{ $inputId }}" class="block mb-2 sm:mb-3 text-sm sm:text-base font-semibold text-gray-900">
            {{ $label }}
            @if($required)
                <span class="text-red-500">*</span>
            @endif
        </label>
    @endif
    
    <textarea 
        id="{{ $inputId }}"
        name="{{ $name }}"
        rows="{{ $rows }}"
        @if($placeholder) placeholder="{{ $placeholder }}" @endif
        @if($required) required @endif
        {{ $attributes->merge([
            'class' => 'bg-gray-50 border-2 text-gray-900 text-sm sm:text-base rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 block w-full p-3 sm:p-4 transition resize-y ' . ($hasError ? 'border-red-500 focus:ring-red-500' : 'border-gray-300')
        ]) }}
    >{{ $inputValue }}</textarea>
    
    @if($hasError)
        <p class="mt-1 text-sm text-red-600">{{ $errorMessage }}</p>
    @endif
</div>
