@props([
    'id',
    'title' => 'Confirmar ação',
    'message',
    'confirmLabel' => 'Confirmar',
    'cancelLabel' => 'Cancelar',
    'variant' => 'primary', // primary, danger
    'confirmAction' => null, // URL ou função JS
])

@php
    $confirmButtonVariant = $variant === 'danger' ? 'danger' : 'primary';
@endphp

<!-- Modal -->
<div 
    id="{{ $id }}" 
    tabindex="-1" 
    aria-hidden="true"
    class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full"
    data-modal-backdrop="static"
>
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                <h3 class="text-lg font-semibold text-gray-900">
                    {{ $title }}
                </h3>
                <button 
                    type="button" 
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                    data-modal-hide="{{ $id }}"
                >
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Fechar</span>
                </button>
            </div>
            
            <!-- Modal body -->
            <div class="p-4 md:p-5">
                <p class="text-gray-500 mb-4">{{ $message }}</p>
            </div>
            
            <!-- Modal footer -->
            <div class="flex items-center p-4 md:p-5 border-t border-gray-200 rounded-b">
                @if($confirmAction)
                    <form method="POST" action="{{ $confirmAction }}" class="inline">
                        @csrf
                        <x-button type="submit" variant="{{ $confirmButtonVariant }}">
                            {{ $confirmLabel }}
                        </x-button>
                    </form>
                @else
                    <x-button 
                        variant="{{ $confirmButtonVariant }}"
                        data-modal-confirm="{{ $id }}"
                    >
                        {{ $confirmLabel }}
                    </x-button>
                @endif
                
                <x-button 
                    variant="secondary"
                    data-modal-hide="{{ $id }}"
                    class="ms-3"
                >
                    {{ $cancelLabel }}
                </x-button>
            </div>
        </div>
    </div>
</div>

<!-- Backdrop -->
<div 
    id="{{ $id }}-backdrop" 
    class="hidden fixed inset-0 bg-gray-900 bg-opacity-50 z-40"
    data-modal-hide="{{ $id }}"
></div>
