<x-app-layout>
    <x-slot name="page-title">Novo Episódio</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li><a href="{{ route('episodes.index') }}" class="hover:text-gray-900">Episódios</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Novo</li>
    </x-slot>

    <div class="max-w-4xl">
        <h1 class="text-2xl font-bold text-gray-900 mb-6">Novo Episódio</h1>

        <form 
            id="episode-form"
            method="POST" 
            action="{{ route('episodes.store') }}"
            x-data="episodeForm()"
            @submit.prevent="submitForm"
        >
            @csrf

            <x-card>
                <div class="space-y-6">
                    <!-- Título -->
                    <x-form.input 
                        name="title"
                        label="Título"
                        placeholder="Ex: Episódio 1: GovTech e Inovação"
                        required
                        x-model="formData.title"
                    />

                    <!-- Datas -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <x-form.input 
                            name="record_date"
                            label="Data de Gravação"
                            type="date"
                            x-model="formData.record_date"
                        />

                        <x-form.input 
                            name="publish_date"
                            label="Data de Publicação"
                            type="date"
                            x-model="formData.publish_date"
                        />
                    </div>

                    <!-- Convidados -->
                    <x-form.multiselect 
                        name="guests"
                        label="Convidados"
                        :options="$guests->map(fn($g) => ['id' => $g->id, 'name' => $g->name])->toArray()"
                        placeholder="Selecione os convidados"
                        :value="[]"
                    />

                    <!-- Temas -->
                    <x-form.multiselect 
                        name="themes"
                        label="Temas"
                        :options="$themes->map(fn($t) => ['id' => $t->id, 'name' => $t->name])->toArray()"
                        placeholder="Selecione os temas"
                        :value="[]"
                    />

                    <!-- Descrição -->
                    <x-form.textarea 
                        name="description"
                        label="Descrição"
                        placeholder="Descrição do episódio..."
                        rows="4"
                        x-model="formData.description"
                    />

                    <!-- Tags -->
                    <x-form.input 
                        name="tags"
                        label="Tags"
                        placeholder="govtech, inovação, setor público"
                        x-model="formData.tags"
                    />

                    <!-- Botões -->
                    <div class="flex gap-4 pt-4">
                        <button 
                            type="submit"
                            :disabled="submitting"
                            class="inline-flex items-center justify-center font-medium rounded-lg focus:outline-none focus:ring-4 transition-colors text-white bg-blue-600 hover:bg-blue-700 focus:ring-blue-300 px-4 py-2 text-sm disabled:opacity-50 disabled:cursor-not-allowed"
                        >
                            <span x-show="!submitting">Salvar</span>
                            <span x-show="submitting" style="display: none;">Salvando...</span>
                        </button>
                        <a href="{{ route('episodes.index') }}" class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100">
                            Cancelar
                        </a>
                    </div>
                </div>
            </x-card>
        </form>
    </div>

    @push('scripts')
    <script>
        function episodeForm() {
            return {
                submitting: false,
                formData: {
                    title: '',
                    record_date: '',
                    publish_date: '',
                    description: '',
                    tags: '',
                },
                
                async submitForm() {
                    if (!window.validateForm(document.getElementById('episode-form'))) {
                        return;
                    }
                    
                    this.submitting = true;
                    
                    try {
                        // Coleta dados do formulário
                        const formData = new FormData(document.getElementById('episode-form'));
                        
                        // Converte para JSON
                        // Gera slug a partir do título
                        const title = formData.get('title');
                        const slug = title.toLowerCase()
                            .normalize('NFD')
                            .replace(/[\u0300-\u036f]/g, '')
                            .replace(/[^a-z0-9]+/g, '-')
                            .replace(/(^-|-$)/g, '');
                        
                        const data = {
                            title: title,
                            slug: slug,
                            record_date: formData.get('record_date') || null,
                            publish_date: formData.get('publish_date') || null,
                            description: formData.get('description') || null,
                            tags: formData.get('tags') || null,
                            status: 'pauta', // Status padrão
                            guests: Array.from(formData.getAll('guests[]')).map(Number).filter(id => id > 0),
                            themes: Array.from(formData.getAll('themes[]')).map(Number).filter(id => id > 0),
                        };
                        
                        const response = await window.apiFetch('/api/episodes', {
                            method: 'POST',
                            body: data,
                        });
                        
                        window.showToast('Episódio criado com sucesso!', 'success');
                        window.location.href = `/episodes/${response.data.id}`;
                    } catch (error) {
                        console.error('Erro ao criar episódio:', error);
                        
                        if (error.errors) {
                            window.mapApiErrorsToFields(error.errors, document.getElementById('episode-form'));
                            window.showToast('Corrija os erros do formulário', 'error');
                        } else {
                            window.showToast('Erro ao criar episódio', 'error');
                        }
                    } finally {
                        this.submitting = false;
                    }
                }
            }
        }
    </script>
    @endpush
</x-app-layout>
