<x-app-layout>
    <x-slot name="page-title">{{ $episode->title }}</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li><a href="{{ route('episodes.index') }}" class="hover:text-gray-900">Episódios</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">{{ \Illuminate\Support\Str::limit($episode->title, 30) }}</li>
    </x-slot>

    <div class="space-y-6" x-data="episodeDetail({{ $episode->id }})">
        <!-- Header com Ações -->
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                <h1 class="text-2xl font-bold text-gray-900">{{ $episode->title }}</h1>
                <x-badge-status :status="$episode->status" />
            </div>
            <div class="flex gap-2">
                <a 
                    href="{{ route('episodes.edit', $episode) }}"
                    class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                >
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Editar
                </a>
                <div class="relative">
                    <x-episodes.partials.status-transition :episode="$episode" />
                </div>
            </div>
        </div>

        <!-- Informações Principais -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Convidados -->
            <x-card>
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Convidados</h2>
                @if($episode->guests->count() > 0)
                    <div class="flex flex-wrap gap-2">
                        @foreach($episode->guests as $guest)
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-100 text-gray-800">
                                {{ $guest->name }}
                                @if($guest->role_title)
                                    <span class="ml-1 text-gray-500">({{ $guest->role_title }})</span>
                                @endif
                            </span>
                        @endforeach
                    </div>
                @else
                    <p class="text-gray-500">Nenhum convidado associado</p>
                @endif
            </x-card>

            <!-- Temas -->
            <x-card>
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Temas</h2>
                @if($episode->themes->count() > 0)
                    <div class="flex flex-wrap gap-2">
                        @foreach($episode->themes as $theme)
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                {{ $theme->name }}
                            </span>
                        @endforeach
                    </div>
                @else
                    <p class="text-gray-500">Nenhum tema associado</p>
                @endif
            </x-card>
        </div>

        <!-- Datas -->
        <x-card>
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Datas</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <span class="text-sm text-gray-600">Gravação:</span>
                    <p class="text-gray-900 font-medium">
                        {{ $episode->record_date ? $episode->record_date->format('d/m/Y') : '—' }}
                    </p>
                </div>
                <div>
                    <span class="text-sm text-gray-600">Publicação:</span>
                    <p class="text-gray-900 font-medium">
                        {{ $episode->publish_date ? $episode->publish_date->format('d/m/Y') : '—' }}
                    </p>
                </div>
            </div>
        </x-card>

        <!-- Descrição -->
        @if($episode->description)
        <x-card>
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Descrição</h2>
            <p class="text-gray-700 whitespace-pre-wrap">{{ $episode->description }}</p>
        </x-card>
        @endif

        <!-- Tags -->
        @if($episode->tags)
        <x-card>
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Tags</h2>
            <div class="flex flex-wrap gap-2">
                @foreach(explode(',', $episode->tags) as $tag)
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800">
                        {{ trim($tag) }}
                    </span>
                @endforeach
            </div>
        </x-card>
        @endif

        <!-- Checklist Editorial -->
        <x-card id="checklist">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Checklist Editorial</h2>
            <x-episodes.partials.task-checklist :episode="$episode" />
        </x-card>

        <!-- Assets -->
        <x-card id="assets">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Assets</h2>
            <x-episodes.partials.asset-list :episode="$episode" />
        </x-card>
    </div>

</x-app-layout>
