<x-app-layout>
    <x-slot name="page-title">Novo Convidado</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li><a href="{{ route('guests.index') }}" class="hover:text-gray-900">Convidados</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Novo</li>
    </x-slot>

    <div class="space-y-6" x-data="guestForm()">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">Novo Convidado</h1>
        </div>

        <x-card>
            <form @submit.prevent="submitForm" class="space-y-6">
                <!-- Nome -->
                <div>
                    <x-form.input 
                        label="Nome"
                        name="name"
                        x-model="form.name"
                        required
                        :error="$errors->first('name')"
                    />
                </div>

                <!-- Cargo/Atuação -->
                <div>
                    <x-form.input 
                        label="Cargo/Atuação"
                        name="role_title"
                        x-model="form.role_title"
                        :error="$errors->first('role_title')"
                    />
                </div>

                <!-- Organização -->
                <div>
                    <x-form.input 
                        label="Organização"
                        name="organization"
                        x-model="form.organization"
                        :error="$errors->first('organization')"
                    />
                </div>

                <!-- Bio Curta -->
                <div>
                    <x-form.textarea 
                        label="Bio Curta"
                        name="bio_short"
                        x-model="form.bio_short"
                        rows="4"
                        :error="$errors->first('bio_short')"
                    />
                </div>

                <!-- LinkedIn -->
                <div>
                    <x-form.input 
                        label="LinkedIn URL"
                        name="linkedin_url"
                        type="url"
                        x-model="form.linkedin_url"
                        placeholder="https://linkedin.com/in/..."
                        :error="$errors->first('linkedin_url')"
                    />
                </div>

                <!-- Website -->
                <div>
                    <x-form.input 
                        label="Website URL"
                        name="website_url"
                        type="url"
                        x-model="form.website_url"
                        placeholder="https://..."
                        :error="$errors->first('website_url')"
                    />
                </div>

                <!-- Botões -->
                <div class="flex justify-end gap-3">
                    <a 
                        href="{{ route('guests.index') }}"
                        class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                    >
                        Cancelar
                    </a>
                    <button 
                        type="submit"
                        :disabled="submitting"
                        class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700 disabled:opacity-50"
                    >
                        <span x-show="!submitting">Criar Convidado</span>
                        <span x-show="submitting" style="display: none;">Criando...</span>
                    </button>
                </div>
            </form>
        </x-card>
    </div>

    @push('scripts')
    <script>
        function guestForm() {
            return {
                submitting: false,
                form: {
                    name: '',
                    role_title: '',
                    organization: '',
                    bio_short: '',
                    linkedin_url: '',
                    website_url: '',
                },
                errors: {},
                
                async submitForm() {
                    this.submitting = true;
                    window.clearFormErrors();
                    
                    try {
                        const response = await window.apiFetch('/api/guests', {
                            method: 'POST',
                            body: this.form,
                        });
                        
                        window.showToast('Convidado criado com sucesso!', 'success');
                        window.location.href = '/guests';
                    } catch (error) {
                        console.error('Erro ao criar convidado:', error);
                        if (error.errors) {
                            this.errors = error.errors;
                            window.mapApiErrorsToFields(error.errors, document.querySelector('[x-data*="guestForm"]'));
                            window.showToast('Corrija os erros do formulário', 'error');
                        } else {
                            window.showToast('Erro ao criar convidado', 'error');
                        }
                    } finally {
                        this.submitting = false;
                    }
                }
            }
        }
    </script>
    @endpush
</x-app-layout>
