<x-app-layout>
    <x-slot name="page-title">Convidados</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Convidados</li>
    </x-slot>

    <div class="space-y-6" x-data="guestsList()">
        <!-- Header com CTA -->
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">Convidados</h1>
            <a href="{{ route('guests.create') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Novo Convidado
            </a>
        </div>

        <!-- Busca -->
        <x-card>
            <div class="flex gap-4">
                <div class="flex-1">
                    <input 
                        type="text"
                        x-model="search"
                        @input.debounce.500ms="loadGuests()"
                        placeholder="Buscar por nome, cargo ou organização..."
                        class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                    >
                </div>
            </div>
        </x-card>

        <!-- Loading State -->
        <div x-show="loading" class="text-center py-12">
            <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-blue-600"></div>
            <p class="mt-2 text-gray-600">Carregando convidados...</p>
        </div>

        <!-- Empty State -->
        <x-empty-state 
            x-show="!loading && guests.length === 0"
            title="Nenhum convidado encontrado"
            description="Comece criando seu primeiro convidado!"
            action-label="Criar Convidado"
            action-url="{{ route('guests.create') }}"
            style="display: none;"
        />

        <!-- Tabela de Convidados -->
        <x-card :padding="false" x-show="!loading && guests.length > 0" style="display: none;">
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-500">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3">Nome</th>
                            <th scope="col" class="px-6 py-3">Cargo/Atuação</th>
                            <th scope="col" class="px-6 py-3">Organização</th>
                            <th scope="col" class="px-6 py-3">Episódios</th>
                            <th scope="col" class="px-6 py-3">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-for="guest in guests" :key="guest.id">
                            <tr class="bg-white border-b hover:bg-gray-50">
                                <td class="px-6 py-4 font-medium text-gray-900" x-text="guest.name"></td>
                                <td class="px-6 py-4" x-text="guest.role_title || '—'"></td>
                                <td class="px-6 py-4" x-text="guest.organization || '—'"></td>
                                <td class="px-6 py-4">
                                    <span class="text-gray-600" x-text="guest.episodes_count || 0"></span>
                                </td>
                                <td class="px-6 py-4">
                                    <a 
                                        :href="`/guests/${guest.id}/edit`"
                                        class="text-blue-600 hover:text-blue-800 font-medium"
                                    >
                                        Editar
                                    </a>
                                </td>
                            </tr>
                        </template>
                    </tbody>
                </table>
            </div>

            <!-- Paginação -->
            <div x-show="pagination && pagination.total > 0" class="px-6 py-4 border-t border-gray-200" style="display: none;">
                <div class="flex items-center justify-between">
                    <div class="text-sm text-gray-700">
                        Mostrando <span x-text="pagination?.from || 0"></span> a <span x-text="pagination?.to || 0"></span> de <span x-text="pagination?.total || 0"></span> convidados
                    </div>
                    <div class="flex gap-2">
                        <button 
                            @click="loadGuests((pagination?.current_page || 1) - 1)"
                            :disabled="!pagination || pagination.current_page === 1"
                            :class="(!pagination || pagination.current_page === 1) ? 'opacity-50 cursor-not-allowed' : ''"
                            class="px-3 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                        >
                            Anterior
                        </button>
                        <button 
                            @click="loadGuests((pagination?.current_page || 1) + 1)"
                            :disabled="!pagination || pagination.current_page === pagination.last_page"
                            :class="(!pagination || pagination.current_page === pagination.last_page) ? 'opacity-50 cursor-not-allowed' : ''"
                            class="px-3 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                        >
                            Próxima
                        </button>
                    </div>
                </div>
            </div>
        </x-card>
    </div>

    @push('scripts')
    <script>
        function guestsList() {
            return {
                loading: true,
                guests: [],
                pagination: null,
                search: '',
                
                init() {
                    this.loadGuests();
                },
                
                async loadGuests(page = 1) {
                    this.loading = true;
                    
                    try {
                        const params = new URLSearchParams({
                            page: page,
                        });
                        
                        if (this.search) {
                            params.append('q', this.search);
                        }
                        
                        const response = await window.apiFetch(`/api/guests?${params.toString()}`);
                        
                        if (response.data && Array.isArray(response.data)) {
                            this.guests = response.data;
                            this.pagination = response.meta || null;
                        } else {
                            this.guests = [];
                            this.pagination = null;
                        }
                    } catch (error) {
                        console.error('Erro ao carregar convidados:', error);
                        window.showToast('Erro ao carregar convidados', 'error');
                    } finally {
                        this.loading = false;
                    }
                }
            }
        }
    </script>
    @endpush
</x-app-layout>
