<x-app-layout>
    <x-slot name="page-title">Novo Prospect</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li><a href="{{ route('prospects.index') }}" class="hover:text-gray-900">Curadoria</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Novo</li>
    </x-slot>

    <div class="space-y-6">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">Novo Prospect</h1>
        </div>

        <x-card>
            <form method="POST" action="{{ route('prospects.store') }}" class="space-y-6">
                @csrf

                <!-- Identificação -->
                <div class="border-b border-gray-200 pb-6">
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Identificação</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Tipo *</label>
                            <select name="type" required class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5">
                                <option value="person" {{ old('type') == 'person' ? 'selected' : '' }}>Pessoa</option>
                                <option value="company" {{ old('type') == 'company' ? 'selected' : '' }}>Empresa</option>
                            </select>
                        </div>
                        <div>
                            <x-form.input 
                                label="Nome *"
                                name="name"
                                value="{{ old('name') }}"
                                required
                                :error="$errors->first('name')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="E-mail *"
                                name="email"
                                type="email"
                                value="{{ old('email') }}"
                                required
                                :error="$errors->first('email')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="WhatsApp"
                                name="whatsapp"
                                value="{{ old('whatsapp') }}"
                                :error="$errors->first('whatsapp')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="LinkedIn"
                                name="linkedin_url"
                                type="url"
                                value="{{ old('linkedin_url') }}"
                                :error="$errors->first('linkedin_url')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="Website"
                                name="website_url"
                                type="url"
                                value="{{ old('website_url') }}"
                                :error="$errors->first('website_url')"
                            />
                        </div>
                    </div>
                </div>

                <!-- Perfil -->
                <div class="border-b border-gray-200 pb-6">
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Perfil</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Tipo de Organização</label>
                            <select name="organization_type" class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5">
                                <option value="">Selecione...</option>
                                <option value="startup" {{ old('organization_type') == 'startup' ? 'selected' : '' }}>Startup</option>
                                <option value="empresa" {{ old('organization_type') == 'empresa' ? 'selected' : '' }}>Empresa</option>
                                <option value="governo" {{ old('organization_type') == 'governo' ? 'selected' : '' }}>Governo</option>
                                <option value="academia" {{ old('organization_type') == 'academia' ? 'selected' : '' }}>Academia</option>
                                <option value="osc" {{ old('organization_type') == 'osc' ? 'selected' : '' }}>OSC</option>
                                <option value="hub" {{ old('organization_type') == 'hub' ? 'selected' : '' }}>Hub/Ambiente</option>
                                <option value="outro" {{ old('organization_type') == 'outro' ? 'selected' : '' }}>Outro</option>
                            </select>
                        </div>
                        <div>
                            <x-form.input 
                                label="Nome da Organização"
                                name="company_name"
                                value="{{ old('company_name') }}"
                                :error="$errors->first('company_name')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="Cargo/Função"
                                name="role_title"
                                value="{{ old('role_title') }}"
                                :error="$errors->first('role_title')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="Localização"
                                name="location"
                                value="{{ old('location') }}"
                                :error="$errors->first('location')"
                            />
                        </div>
                    </div>
                </div>

                <!-- Curadoria -->
                <div class="border-b border-gray-200 pb-6">
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Curadoria</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Origem</label>
                            <select name="origin" class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5">
                                <option value="outbound_curated" {{ old('origin', 'outbound_curated') == 'outbound_curated' ? 'selected' : '' }}>Curadoria Externa</option>
                                <option value="referral" {{ old('origin') == 'referral' ? 'selected' : '' }}>Indicação</option>
                                <option value="event" {{ old('origin') == 'event' ? 'selected' : '' }}>Evento</option>
                                <option value="other" {{ old('origin') == 'other' ? 'selected' : '' }}>Outro</option>
                            </select>
                        </div>
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Status</label>
                            <select name="status" class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5">
                                <option value="to_review" {{ old('status', 'to_review') == 'to_review' ? 'selected' : '' }}>Para Revisar</option>
                                <option value="approved" {{ old('status') == 'approved' ? 'selected' : '' }}>Aprovado</option>
                                <option value="invited" {{ old('status') == 'invited' ? 'selected' : '' }}>Convidado</option>
                            </select>
                        </div>
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Prioridade (1-5)</label>
                            <input 
                                type="number" 
                                name="priority" 
                                min="1" 
                                max="5"
                                value="{{ old('priority') }}"
                                class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                            >
                        </div>
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Fit Score (1-5)</label>
                            <input 
                                type="number" 
                                name="fit_score" 
                                min="1" 
                                max="5"
                                value="{{ old('fit_score') }}"
                                class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                            >
                        </div>
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Impact Potential (1-5)</label>
                            <input 
                                type="number" 
                                name="impact_potential" 
                                min="1" 
                                max="5"
                                value="{{ old('impact_potential') }}"
                                class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                            >
                        </div>
                        <div>
                            <label class="block mb-2 text-sm font-medium text-gray-900">Timing Score (1-5)</label>
                            <input 
                                type="number" 
                                name="timing_score" 
                                min="1" 
                                max="5"
                                value="{{ old('timing_score') }}"
                                class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                            >
                        </div>
                        <div class="md:col-span-2">
                            <x-form.textarea 
                                label="Notas Editoriais"
                                name="notes"
                                rows="3"
                                :error="$errors->first('notes')"
                            >{{ old('notes') }}</x-form.textarea>
                        </div>
                    </div>
                </div>

                <!-- Temas -->
                <div class="pb-6">
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Temas</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-2 max-h-64 overflow-y-auto border border-gray-300 rounded-lg p-3">
                        @foreach($themes as $theme)
                            <label class="flex items-center space-x-2 cursor-pointer hover:bg-gray-50 p-2 rounded">
                                <input 
                                    type="checkbox" 
                                    name="themes[]" 
                                    value="{{ $theme->id }}"
                                    {{ in_array($theme->id, old('themes', [])) ? 'checked' : '' }}
                                    class="rounded border-gray-300 text-blue-600 focus:ring-blue-500"
                                >
                                <span class="text-sm text-gray-700">{{ $theme->name }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                <!-- Botões -->
                <div class="flex justify-end gap-3">
                    <a href="{{ route('prospects.index') }}" class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100">
                        Cancelar
                    </a>
                    <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700">
                        Criar Prospect
                    </button>
                </div>
            </form>
        </x-card>
    </div>
</x-app-layout>
