<x-app-layout>
    <x-slot name="page-title">Curadoria - Prospects</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Curadoria</li>
    </x-slot>

    <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Curadoria</h1>
                <p class="text-sm text-gray-600 mt-1">Gerencie prospects e o pipeline de curadoria</p>
            </div>
            <a href="{{ route('prospects.create') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Novo Prospect
            </a>
        </div>

        <!-- Filtros -->
        <x-card>
            <form method="GET" action="{{ route('prospects.index') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Busca -->
                <div class="md:col-span-2">
                    <label class="block mb-2 text-sm font-medium text-gray-900">Buscar</label>
                    <input 
                        type="text"
                        name="search"
                        value="{{ request('search') }}"
                        placeholder="Nome, e-mail ou organização..."
                        class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                    >
                </div>

                <!-- Status -->
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900">Status</label>
                    <select name="status" class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5">
                        <option value="">Todos</option>
                        @foreach($statuses as $value => $label)
                            <option value="{{ $value }}" {{ request('status') == $value ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Origem -->
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900">Origem</label>
                    <select name="origin" class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5">
                        <option value="">Todas</option>
                        @foreach($origins as $value => $label)
                            <option value="{{ $value }}" {{ request('origin') == $value ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Botões -->
                <div class="md:col-span-4 flex gap-2">
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                        Filtrar
                    </button>
                    <a href="{{ route('prospects.index') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                        Limpar
                    </a>
                </div>
            </form>
        </x-card>

        <!-- Tabela -->
        @if($prospects->count() > 0)
            <x-card :padding="false">
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left text-gray-500">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3">Nome</th>
                                <th scope="col" class="px-6 py-3">E-mail</th>
                                <th scope="col" class="px-6 py-3">Organização</th>
                                <th scope="col" class="px-6 py-3">Status</th>
                                <th scope="col" class="px-6 py-3">Origem</th>
                                <th scope="col" class="px-6 py-3">Score</th>
                                <th scope="col" class="px-6 py-3">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($prospects as $prospect)
                                <tr class="bg-white border-b hover:bg-gray-50">
                                    <td class="px-6 py-4 font-medium text-gray-900">
                                        <a href="{{ route('prospects.show', $prospect) }}" class="hover:text-blue-600">
                                            {{ $prospect->name }}
                                        </a>
                                    </td>
                                    <td class="px-6 py-4">{{ $prospect->email }}</td>
                                    <td class="px-6 py-4">{{ $prospect->company_name ?? '—' }}</td>
                                    <td class="px-6 py-4">
                                        @php
                                            $statusLabels = [
                                                'to_review' => 'Para Revisar',
                                                'approved' => 'Aprovado',
                                                'invited' => 'Convidado',
                                                'in_conversation' => 'Em Conversa',
                                                'scheduled' => 'Agendado',
                                                'confirmed' => 'Confirmado',
                                                'rejected' => 'Rejeitado',
                                                'archived' => 'Arquivado',
                                            ];
                                            $statusColors = [
                                                'to_review' => 'bg-yellow-100 text-yellow-800',
                                                'approved' => 'bg-green-100 text-green-800',
                                                'invited' => 'bg-blue-100 text-blue-800',
                                                'in_conversation' => 'bg-purple-100 text-purple-800',
                                                'scheduled' => 'bg-indigo-100 text-indigo-800',
                                                'confirmed' => 'bg-green-100 text-green-800',
                                                'rejected' => 'bg-red-100 text-red-800',
                                                'archived' => 'bg-gray-100 text-gray-800',
                                            ];
                                        @endphp
                                        <span class="px-2 py-1 rounded-full text-xs font-medium {{ $statusColors[$prospect->status] ?? 'bg-gray-100 text-gray-800' }}">
                                            {{ $statusLabels[$prospect->status] ?? $prospect->status }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="text-xs text-gray-600">{{ $origins[$prospect->origin] ?? $prospect->origin }}</span>
                                    </td>
                                    <td class="px-6 py-4">
                                        @if($prospect->total_score)
                                            <span class="font-semibold">{{ $prospect->total_score }}/15</span>
                                        @else
                                            <span class="text-gray-400">—</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="flex gap-2">
                                            <a href="{{ route('prospects.show', $prospect) }}" class="text-blue-600 hover:text-blue-800">
                                                Ver
                                            </a>
                                            <a href="{{ route('prospects.edit', $prospect) }}" class="text-gray-600 hover:text-gray-800">
                                                Editar
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Paginação -->
                @if($prospects->hasPages())
                    <div class="px-6 py-4 border-t border-gray-200">
                        {{ $prospects->links() }}
                    </div>
                @endif
            </x-card>
        @else
            <x-empty-state 
                title="Nenhum prospect encontrado"
                description="Comece criando seu primeiro prospect ou ajuste os filtros."
                action-label="Criar Prospect"
                action-url="{{ route('prospects.create') }}"
            />
        @endif
    </div>
</x-app-layout>
