<x-app-layout>
    <x-slot name="page-title">Prospect: {{ $prospect->name }}</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li><a href="{{ route('prospects.index') }}" class="hover:text-gray-900">Curadoria</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">{{ $prospect->name }}</li>
    </x-slot>

    <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">{{ $prospect->name }}</h1>
                <p class="text-sm text-gray-600 mt-1">{{ $prospect->email }}</p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('prospects.edit', $prospect) }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Editar
                </a>
                @if($prospect->status === \App\Models\Prospect::STATUS_TO_REVIEW)
                    <form method="POST" action="{{ route('prospects.approve', $prospect) }}" class="inline">
                        @csrf
                        <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                            Aprovar
                        </button>
                    </form>
                    <button 
                        type="button"
                        onclick="document.getElementById('reject-modal').classList.remove('hidden')"
                        class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700"
                    >
                        Rejeitar
                    </button>
                @endif
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Coluna Principal -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Informações Básicas -->
                <x-card>
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Informações Básicas</h2>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-sm font-medium text-gray-500">Tipo</label>
                            <p class="text-gray-900">{{ $prospect->type === 'person' ? 'Pessoa' : 'Empresa' }}</p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-500">E-mail</label>
                            <p class="text-gray-900">{{ $prospect->email }}</p>
                        </div>
                        @if($prospect->whatsapp)
                            <div>
                                <label class="text-sm font-medium text-gray-500">WhatsApp</label>
                                <p class="text-gray-900">{{ $prospect->whatsapp }}</p>
                            </div>
                        @endif
                        @if($prospect->linkedin_url)
                            <div>
                                <label class="text-sm font-medium text-gray-500">LinkedIn</label>
                                <p class="text-gray-900">
                                    <a href="{{ $prospect->linkedin_url }}" target="_blank" class="text-blue-600 hover:underline">
                                        Ver perfil
                                    </a>
                                </p>
                            </div>
                        @endif
                        @if($prospect->company_name)
                            <div>
                                <label class="text-sm font-medium text-gray-500">Organização</label>
                                <p class="text-gray-900">{{ $prospect->company_name }}</p>
                            </div>
                        @endif
                        @if($prospect->role_title)
                            <div>
                                <label class="text-sm font-medium text-gray-500">Cargo/Função</label>
                                <p class="text-gray-900">{{ $prospect->role_title }}</p>
                            </div>
                        @endif
                        @if($prospect->location)
                            <div>
                                <label class="text-sm font-medium text-gray-500">Localização</label>
                                <p class="text-gray-900">{{ $prospect->location }}</p>
                            </div>
                        @endif
                    </div>
                </x-card>

                <!-- Sobre a Iniciativa -->
                @if($prospect->what_they_do || $prospect->problem_solved || $prospect->stage)
                    <x-card>
                        <h2 class="text-lg font-semibold text-gray-900 mb-4">Sobre a Iniciativa</h2>
                        <div class="space-y-4">
                            @if($prospect->what_they_do)
                                <div>
                                    <label class="text-sm font-medium text-gray-500">O que fazem</label>
                                    <p class="text-gray-900 mt-1">{{ $prospect->what_they_do }}</p>
                                </div>
                            @endif
                            @if($prospect->problem_solved)
                                <div>
                                    <label class="text-sm font-medium text-gray-500">Problema que resolvem</label>
                                    <p class="text-gray-900 mt-1">{{ $prospect->problem_solved }}</p>
                                </div>
                            @endif
                            @if($prospect->stage)
                                <div>
                                    <label class="text-sm font-medium text-gray-500">Estágio</label>
                                    <p class="text-gray-900 mt-1">
                                        @php
                                            $stages = [
                                                'ideacao' => 'Ideação',
                                                'mvp' => 'MVP',
                                                'tracao' => 'Tração',
                                                'escala' => 'Escala',
                                                'consolidacao' => 'Consolidação',
                                            ];
                                        @endphp
                                        {{ $stages[$prospect->stage] ?? $prospect->stage }}
                                    </p>
                                </div>
                            @endif
                        </div>
                    </x-card>
                @endif

                <!-- Pauta e Valor -->
                @if($prospect->expertise_topics || $prospect->story_case || $prospect->themes->count() > 0)
                    <x-card>
                        <h2 class="text-lg font-semibold text-gray-900 mb-4">Pauta e Valor</h2>
                        <div class="space-y-4">
                            @if($prospect->themes->count() > 0)
                                <div>
                                    <label class="text-sm font-medium text-gray-500">Temas</label>
                                    <div class="flex flex-wrap gap-2 mt-2">
                                        @foreach($prospect->themes as $theme)
                                            <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm">
                                                {{ $theme->name }}
                                            </span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            @if($prospect->expertise_topics)
                                <div>
                                    <label class="text-sm font-medium text-gray-500">Tópicos que domina</label>
                                    <p class="text-gray-900 mt-1">{{ $prospect->expertise_topics }}</p>
                                </div>
                            @endif
                            @if($prospect->story_case)
                                <div>
                                    <label class="text-sm font-medium text-gray-500">História/Caso real</label>
                                    <p class="text-gray-900 mt-1">{{ $prospect->story_case }}</p>
                                </div>
                            @endif
                        </div>
                    </x-card>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- Status e Curadoria -->
                <x-card>
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Curadoria</h2>
                    <div class="space-y-4">
                        <div>
                            <label class="text-sm font-medium text-gray-500">Status</label>
                            <p class="text-gray-900 mt-1">
                                @php
                                    $statusLabels = [
                                        'to_review' => 'Para Revisar',
                                        'approved' => 'Aprovado',
                                        'invited' => 'Convidado',
                                        'in_conversation' => 'Em Conversa',
                                        'scheduled' => 'Agendado',
                                        'confirmed' => 'Confirmado',
                                        'rejected' => 'Rejeitado',
                                        'archived' => 'Arquivado',
                                    ];
                                @endphp
                                <span class="px-3 py-1 rounded-full text-sm font-medium
                                    @if($prospect->status === 'approved') bg-green-100 text-green-800
                                    @elseif($prospect->status === 'rejected') bg-red-100 text-red-800
                                    @elseif($prospect->status === 'to_review') bg-yellow-100 text-yellow-800
                                    @else bg-blue-100 text-blue-800
                                    @endif">
                                    {{ $statusLabels[$prospect->status] ?? $prospect->status }}
                                </span>
                            </p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-500">Origem</label>
                            <p class="text-gray-900 mt-1">
                                @php
                                    $originLabels = [
                                        'inbound_form' => 'Formulário Público',
                                        'outbound_curated' => 'Curadoria Externa',
                                        'referral' => 'Indicação',
                                        'event' => 'Evento',
                                        'other' => 'Outro',
                                    ];
                                @endphp
                                {{ $originLabels[$prospect->origin] ?? $prospect->origin }}
                            </p>
                        </div>
                        @if($prospect->priority)
                            <div>
                                <label class="text-sm font-medium text-gray-500">Prioridade</label>
                                <p class="text-gray-900 mt-1">{{ $prospect->priority }}/5</p>
                            </div>
                        @endif
                        @if($prospect->total_score)
                            <div>
                                <label class="text-sm font-medium text-gray-500">Score Total</label>
                                <p class="text-gray-900 mt-1 font-semibold">{{ $prospect->total_score }}/15</p>
                                <div class="mt-2 text-xs text-gray-600">
                                    Fit: {{ $prospect->fit_score ?? '—' }} | 
                                    Impacto: {{ $prospect->impact_potential ?? '—' }} | 
                                    Timing: {{ $prospect->timing_score ?? '—' }}
                                </div>
                            </div>
                        @endif
                        @if($prospect->notes)
                            <div>
                                <label class="text-sm font-medium text-gray-500">Notas Editoriais</label>
                                <p class="text-gray-900 mt-1 text-sm">{{ $prospect->notes }}</p>
                            </div>
                        @endif
                        @if($prospect->rejection_reason)
                            <div>
                                <label class="text-sm font-medium text-red-600">Motivo da Rejeição</label>
                                <p class="text-red-700 mt-1 text-sm">{{ $prospect->rejection_reason }}</p>
                            </div>
                        @endif
                    </div>
                </x-card>

                <!-- Informações do Sistema -->
                <x-card>
                    <h2 class="text-lg font-semibold text-gray-900 mb-4">Sistema</h2>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-500">Criado em:</span>
                            <span class="text-gray-900">{{ $prospect->created_at->format('d/m/Y H:i') }}</span>
                        </div>
                        @if($prospect->creator)
                            <div class="flex justify-between">
                                <span class="text-gray-500">Criado por:</span>
                                <span class="text-gray-900">{{ $prospect->creator->name }}</span>
                            </div>
                        @else
                            <div class="flex justify-between">
                                <span class="text-gray-500">Criado por:</span>
                                <span class="text-gray-900">Formulário Público</span>
                            </div>
                        @endif
                        @if($prospect->guest)
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <a href="{{ route('guests.show', $prospect->guest) }}" class="text-blue-600 hover:text-blue-800 font-medium">
                                    Ver Guest Convertido →
                                </a>
                            </div>
                        @endif
                    </div>
                </x-card>
            </div>
        </div>
    </div>

    <!-- Modal de Rejeição -->
    <div id="reject-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
        <div class="bg-white rounded-lg p-6 max-w-md w-full mx-4">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Rejeitar Prospect</h3>
            <form method="POST" action="{{ route('prospects.reject', $prospect) }}">
                @csrf
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-medium text-gray-900">Motivo da Rejeição *</label>
                    <textarea 
                        name="rejection_reason" 
                        rows="4" 
                        required
                        class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                        placeholder="Descreva o motivo da rejeição..."
                    ></textarea>
                </div>
                <div class="flex gap-2 justify-end">
                    <button 
                        type="button"
                        onclick="document.getElementById('reject-modal').classList.add('hidden')"
                        class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300"
                    >
                        Cancelar
                    </button>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                        Rejeitar
                    </button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
