@extends('layouts.public')

@section('title', 'Manifestar Interesse - ' . config('app.name'))

@section('content')
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 py-6 sm:py-8 lg:py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="mb-6 sm:mb-8 text-center">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-blue-100 rounded-full mb-4">
                <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <h1 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-gray-900 mb-3">Manifestar Interesse</h1>
            <p class="text-base sm:text-lg text-gray-700 max-w-2xl mx-auto leading-relaxed">
                Este formulário é uma <strong class="text-gray-900">manifestação de interesse</strong> em participar de entrevistas.
            </p>
            <p class="text-sm sm:text-base text-gray-600 mt-3 max-w-2xl mx-auto">
                A seleção é curada, alinhada com a pauta e agenda editorial. Todos que preencherem entram no radar e podem ser chamados em ciclos futuros.
            </p>
        </div>

        <!-- Banner (opcional) -->
        @if(file_exists(public_path('images/banners/banner-formulario.jpg')) || 
            file_exists(public_path('images/banners/banner-formulario.png')) ||
            file_exists(public_path('images/banners/banner-formulario.webp')))
            <div class="mb-6 sm:mb-8 rounded-2xl overflow-hidden shadow-lg">
                @php
                    $bannerPath = null;
                    if (file_exists(public_path('images/banners/banner-formulario.webp'))) {
                        $bannerPath = asset('images/banners/banner-formulario.webp');
                    } elseif (file_exists(public_path('images/banners/banner-formulario.jpg'))) {
                        $bannerPath = asset('images/banners/banner-formulario.jpg');
                    } elseif (file_exists(public_path('images/banners/banner-formulario.png'))) {
                        $bannerPath = asset('images/banners/banner-formulario.png');
                    }
                @endphp
                @if($bannerPath)
                    <img 
                        src="{{ $bannerPath }}" 
                        alt="Banner do formulário"
                        class="w-full h-auto object-cover"
                        loading="lazy"
                    >
                @endif
            </div>
        @endif

        <!-- Form -->
        <div class="bg-white shadow-xl rounded-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-blue-600 to-blue-700 h-2"></div>
            <div class="p-4 sm:p-6 lg:p-8">
            <form method="POST" action="{{ route('public.prospects.store') }}" class="space-y-8 sm:space-y-10">
                @csrf

                <!-- Bloco A: Identificação -->
                <div class="border-b border-gray-200 pb-6 sm:pb-8">
                    <div class="flex items-center mb-4 sm:mb-6">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                            <span class="text-blue-600 font-semibold text-sm">1</span>
                        </div>
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900">Identificação</h2>
                    </div>
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6">
                        <div>
                            <x-form.input 
                                label="Nome completo"
                                name="name"
                                value="{{ old('name') }}"
                                required
                                :error="$errors->first('name')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="E-mail"
                                name="email"
                                type="email"
                                value="{{ old('email') }}"
                                required
                                :error="$errors->first('email')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="WhatsApp"
                                name="whatsapp"
                                value="{{ old('whatsapp') }}"
                                placeholder="(41) 99999-9999"
                                :error="$errors->first('whatsapp')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="LinkedIn (opcional)"
                                name="linkedin_url"
                                type="url"
                                value="{{ old('linkedin_url') }}"
                                placeholder="https://linkedin.com/in/..."
                                :error="$errors->first('linkedin_url')"
                            />
                        </div>
                    </div>
                </div>

                <!-- Bloco B: Perfil -->
                <div class="border-b border-gray-200 pb-6 sm:pb-8">
                    <div class="flex items-center mb-4 sm:mb-6">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                            <span class="text-blue-600 font-semibold text-sm">2</span>
                        </div>
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900">Perfil</h2>
                    </div>
                    <div class="space-y-4 sm:space-y-5">
                        <div>
                            <label class="block mb-2 text-sm sm:text-base font-semibold text-gray-900">
                                Você representa: <span class="text-red-500">*</span>
                            </label>
                            <select name="organization_type" required class="bg-gray-50 border-2 border-gray-300 text-gray-900 text-sm sm:text-base rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 block w-full p-3 transition @error('organization_type') border-red-500 @enderror">
                                <option value="">Selecione...</option>
                                <option value="startup" {{ old('organization_type') == 'startup' ? 'selected' : '' }}>Startup</option>
                                <option value="empresa" {{ old('organization_type') == 'empresa' ? 'selected' : '' }}>Empresa</option>
                                <option value="governo" {{ old('organization_type') == 'governo' ? 'selected' : '' }}>Governo</option>
                                <option value="academia" {{ old('organization_type') == 'academia' ? 'selected' : '' }}>Academia</option>
                                <option value="osc" {{ old('organization_type') == 'osc' ? 'selected' : '' }}>OSC</option>
                                <option value="hub" {{ old('organization_type') == 'hub' ? 'selected' : '' }}>Hub/Ambiente</option>
                                <option value="outro" {{ old('organization_type') == 'outro' ? 'selected' : '' }}>Outro</option>
                            </select>
                            @error('organization_type')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <x-form.input 
                                label="Nome da organização"
                                name="company_name"
                                value="{{ old('company_name') }}"
                                required
                                :error="$errors->first('company_name')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="Seu cargo/função"
                                name="role_title"
                                value="{{ old('role_title') }}"
                                required
                                :error="$errors->first('role_title')"
                            />
                        </div>
                        <div>
                            <x-form.input 
                                label="Cidade/Estado"
                                name="location"
                                value="{{ old('location') }}"
                                required
                                :error="$errors->first('location')"
                            />
                        </div>
                    </div>
                </div>

                <!-- Bloco C: Sobre a Iniciativa -->
                <div class="border-b border-gray-200 pb-6 sm:pb-8">
                    <div class="flex items-center mb-4 sm:mb-6">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                            <span class="text-blue-600 font-semibold text-sm">3</span>
                        </div>
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900">Sobre a Iniciativa</h2>
                    </div>
                    <div class="space-y-4 sm:space-y-5">
                        <div>
                            <x-form.textarea 
                                label="Em uma frase: o que vocês fazem?"
                                name="what_they_do"
                                rows="2"
                                required
                                :error="$errors->first('what_they_do')"
                            >{{ old('what_they_do') }}</x-form.textarea>
                        </div>
                        <div>
                            <x-form.textarea 
                                label="Qual problema vocês resolvem e para quem?"
                                name="problem_solved"
                                rows="2"
                                required
                                :error="$errors->first('problem_solved')"
                            >{{ old('problem_solved') }}</x-form.textarea>
                        </div>
                        <div>
                            <label class="block mb-2 text-sm sm:text-base font-semibold text-gray-900">
                                Qual estágio hoje? <span class="text-red-500">*</span>
                            </label>
                            <select name="stage" required class="bg-gray-50 border-2 border-gray-300 text-gray-900 text-sm sm:text-base rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 block w-full p-3 transition @error('stage') border-red-500 @enderror">
                                <option value="">Selecione...</option>
                                <option value="ideacao" {{ old('stage') == 'ideacao' ? 'selected' : '' }}>Ideação</option>
                                <option value="mvp" {{ old('stage') == 'mvp' ? 'selected' : '' }}>MVP</option>
                                <option value="tracao" {{ old('stage') == 'tracao' ? 'selected' : '' }}>Tração</option>
                                <option value="escala" {{ old('stage') == 'escala' ? 'selected' : '' }}>Escala</option>
                                <option value="consolidacao" {{ old('stage') == 'consolidacao' ? 'selected' : '' }}>Consolidação</option>
                            </select>
                            @error('stage')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Bloco D: Pauta e Valor -->
                <div class="border-b border-gray-200 pb-6 sm:pb-8">
                    <div class="flex items-center mb-4 sm:mb-6">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                            <span class="text-blue-600 font-semibold text-sm">4</span>
                        </div>
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900">Pauta e Valor da Entrevista</h2>
                    </div>
                    <div class="space-y-4 sm:space-y-5">
                        <div>
                            <label class="block mb-3 text-sm sm:text-base font-semibold text-gray-900">
                                Qual tema você gostaria de abordar no podcast? <span class="text-red-500">*</span>
                            </label>
                            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-2 sm:gap-3 max-h-64 sm:max-h-72 overflow-y-auto border-2 border-gray-200 rounded-xl p-3 sm:p-4 bg-gray-50">
                                @foreach($themes as $theme)
                                    <label class="flex items-center space-x-2 sm:space-x-3 cursor-pointer hover:bg-white p-2 sm:p-3 rounded-lg transition-all border border-transparent hover:border-blue-200 hover:shadow-sm">
                                        <input 
                                            type="checkbox" 
                                            name="themes[]" 
                                            value="{{ $theme->id }}"
                                            {{ in_array($theme->id, old('themes', [])) ? 'checked' : '' }}
                                            class="w-4 h-4 sm:w-5 sm:h-5 rounded border-gray-300 text-blue-600 focus:ring-2 focus:ring-blue-500 transition"
                                        >
                                        <span class="text-sm sm:text-base text-gray-700 font-medium">{{ $theme->name }}</span>
                                    </label>
                                @endforeach
                            </div>
                            @error('themes')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <x-form.textarea 
                                label="Quais 3 tópicos você domina e consegue falar com profundidade?"
                                name="expertise_topics"
                                rows="3"
                                required
                                :error="$errors->first('expertise_topics')"
                            >{{ old('expertise_topics') }}</x-form.textarea>
                        </div>
                        <div>
                            <x-form.textarea 
                                label="Qual história/caso real você consegue compartilhar?"
                                name="story_case"
                                rows="3"
                                required
                                :error="$errors->first('story_case')"
                            >{{ old('story_case') }}</x-form.textarea>
                        </div>
                        <div>
                            <x-form.textarea 
                                label="Qual 'pedido' você tem para o ecossistema? (ex: parceiros, clientes, talentos, investimento)"
                                name="ecosystem_request"
                                rows="2"
                                :error="$errors->first('ecosystem_request')"
                            >{{ old('ecosystem_request') }}</x-form.textarea>
                        </div>
                    </div>
                </div>

                <!-- Bloco E: Disponibilidade -->
                <div class="border-b border-gray-200 pb-6 sm:pb-8">
                    <div class="flex items-center mb-4 sm:mb-6">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                            <span class="text-blue-600 font-semibold text-sm">5</span>
                        </div>
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900">Disponibilidade e Logística</h2>
                    </div>
                    <div class="space-y-4 sm:space-y-5">
                        <div>
                            <label class="block mb-3 text-sm sm:text-base font-semibold text-gray-900">
                                Formato preferido: <span class="text-red-500">*</span>
                            </label>
                            <div class="flex flex-col sm:flex-row gap-3 sm:gap-4">
                                <label class="flex items-center space-x-2 sm:space-x-3 cursor-pointer p-3 sm:p-4 border-2 border-gray-200 rounded-xl hover:border-blue-300 hover:bg-blue-50 transition-all">
                                    <input 
                                        type="radio" 
                                        name="preferred_format" 
                                        value="presencial"
                                        {{ old('preferred_format') == 'presencial' ? 'checked' : '' }}
                                        required
                                        class="w-4 h-4 sm:w-5 sm:h-5 text-blue-600 focus:ring-2 focus:ring-blue-500"
                                    >
                                    <span class="text-sm sm:text-base text-gray-700 font-medium">Presencial (Curitiba)</span>
                                </label>
                                <label class="flex items-center space-x-2 sm:space-x-3 cursor-pointer p-3 sm:p-4 border-2 border-gray-200 rounded-xl hover:border-blue-300 hover:bg-blue-50 transition-all">
                                    <input 
                                        type="radio" 
                                        name="preferred_format" 
                                        value="online"
                                        {{ old('preferred_format') == 'online' ? 'checked' : '' }}
                                        required
                                        class="w-4 h-4 sm:w-5 sm:h-5 text-blue-600 focus:ring-2 focus:ring-blue-500"
                                    >
                                    <span class="text-sm sm:text-base text-gray-700 font-medium">Online</span>
                                </label>
                            </div>
                            @error('preferred_format')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block mb-3 text-sm sm:text-base font-semibold text-gray-900">
                                Melhor período para entrevista: <span class="text-red-500">*</span>
                            </label>
                            <div class="grid grid-cols-1 sm:grid-cols-3 gap-3">
                                <label class="flex items-center space-x-2 sm:space-x-3 cursor-pointer p-3 sm:p-4 border-2 border-gray-200 rounded-xl hover:border-blue-300 hover:bg-blue-50 transition-all">
                                    <input 
                                        type="radio" 
                                        name="preferred_time" 
                                        value="manha"
                                        {{ old('preferred_time') == 'manha' ? 'checked' : '' }}
                                        required
                                        class="w-4 h-4 sm:w-5 sm:h-5 text-blue-600 focus:ring-2 focus:ring-blue-500"
                                    >
                                    <span class="text-sm sm:text-base text-gray-700 font-medium">Manhã</span>
                                </label>
                                <label class="flex items-center space-x-2 sm:space-x-3 cursor-pointer p-3 sm:p-4 border-2 border-gray-200 rounded-xl hover:border-blue-300 hover:bg-blue-50 transition-all">
                                    <input 
                                        type="radio" 
                                        name="preferred_time" 
                                        value="tarde"
                                        {{ old('preferred_time') == 'tarde' ? 'checked' : '' }}
                                        required
                                        class="w-4 h-4 sm:w-5 sm:h-5 text-blue-600 focus:ring-2 focus:ring-blue-500"
                                    >
                                    <span class="text-sm sm:text-base text-gray-700 font-medium">Tarde</span>
                                </label>
                                <label class="flex items-center space-x-2 sm:space-x-3 cursor-pointer p-3 sm:p-4 border-2 border-gray-200 rounded-xl hover:border-blue-300 hover:bg-blue-50 transition-all">
                                    <input 
                                        type="radio" 
                                        name="preferred_time" 
                                        value="noite"
                                        {{ old('preferred_time') == 'noite' ? 'checked' : '' }}
                                        required
                                        class="w-4 h-4 sm:w-5 sm:h-5 text-blue-600 focus:ring-2 focus:ring-blue-500"
                                    >
                                    <span class="text-sm sm:text-base text-gray-700 font-medium">Noite</span>
                                </label>
                            </div>
                            @error('preferred_time')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <x-form.textarea 
                                label="Janela de disponibilidade (próximas 3 semanas)"
                                name="availability_window"
                                rows="2"
                                :error="$errors->first('availability_window')"
                            >{{ old('availability_window') }}</x-form.textarea>
                        </div>
                    </div>
                </div>

                <!-- Bloco F: Consentimento -->
                <div class="pb-6 sm:pb-8">
                    <div class="flex items-start space-x-3 sm:space-x-4 p-4 sm:p-5 bg-blue-50 border-2 border-blue-100 rounded-xl">
                        <input 
                            type="checkbox" 
                            name="consent_given" 
                            id="consent_given"
                            value="1"
                            {{ old('consent_given') ? 'checked' : '' }}
                            required
                            class="mt-1 w-5 h-5 sm:w-6 sm:h-6 rounded border-gray-300 text-blue-600 focus:ring-2 focus:ring-blue-500 transition"
                        >
                        <div class="flex-1">
                            <label for="consent_given" class="text-sm sm:text-base font-semibold text-gray-900 cursor-pointer">
                                Autorizo contato para curadoria e agendamento <span class="text-red-500">*</span>
                            </label>
                            <p class="mt-2 text-xs sm:text-sm text-gray-600 leading-relaxed">
                                Entendo que este formulário é uma manifestação de interesse e que a participação depende de curadoria editorial e disponibilidade de agenda.
                            </p>
                        </div>
                    </div>
                    @error('consent_given')
                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Botão Submit -->
                <div class="flex flex-col sm:flex-row justify-end gap-3 sm:gap-4 pt-6 sm:pt-8 border-t-2 border-gray-200">
                    <button 
                        type="submit"
                        class="group w-full sm:w-auto px-8 sm:px-10 py-4 sm:py-5 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-bold text-base sm:text-lg rounded-xl hover:from-blue-700 hover:to-blue-800 focus:outline-none focus:ring-4 focus:ring-blue-300 focus:ring-offset-2 shadow-lg hover:shadow-2xl transform hover:-translate-y-1 active:translate-y-0 transition-all duration-200"
                    >
                        <span class="flex items-center justify-center">
                            <!-- Ícone de seta -->
                            <svg class="w-5 h-5 sm:w-6 sm:h-6 mr-2 sm:mr-3 transition-transform group-hover:translate-x-1 group-active:translate-x-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                            </svg>
                            <span>Enviar Manifestação de Interesse</span>
                        </span>
                    </button>
                </div>
            </form>
            </div>
        </div>
        
        <!-- Footer Info -->
        <div class="mt-6 sm:mt-8 text-center">
            <p class="text-xs sm:text-sm text-gray-500">
                Seus dados estão seguros e serão usados apenas para fins de curadoria e contato.
            </p>
        </div>
    </div>
</div>
@endsection
