@extends('layouts.public')

@section('title', 'Obrigado - ' . config('app.name'))

@section('content')
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 py-6 sm:py-8 lg:py-12 px-4 sm:px-6 lg:px-8 flex items-center justify-center">
    <div class="max-w-2xl mx-auto text-center w-full">
        <div class="bg-white shadow-xl rounded-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-green-500 to-green-600 h-2"></div>
            <div class="p-6 sm:p-8 lg:p-12">
                <!-- Ícone de sucesso -->
                <div class="mx-auto flex items-center justify-center h-20 w-20 sm:h-24 sm:w-24 rounded-full bg-gradient-to-br from-green-100 to-green-200 mb-6 sm:mb-8 animate-pulse">
                    <svg class="h-10 w-10 sm:h-12 sm:w-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>

                <!-- Título -->
                <h1 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-gray-900 mb-4 sm:mb-6">
                    Obrigado pela sua manifestação de interesse!
                </h1>

                <!-- Mensagem -->
                <div class="space-y-4 sm:space-y-5 text-gray-700 mb-8 sm:mb-10 text-base sm:text-lg leading-relaxed">
                    <p>
                        Recebemos sua manifestação de interesse em participar do podcast. 
                        Sua informação foi registrada com sucesso e está em nossa base de curadoria.
                    </p>
                    <p>
                        Nossa equipe editorial irá analisar seu perfil e, caso haja alinhamento com nossa pauta e agenda, 
                        entraremos em contato para agendar uma entrevista.
                    </p>
                    <p class="text-sm sm:text-base text-gray-600 bg-gray-50 p-4 sm:p-5 rounded-xl border border-gray-200">
                        Todos que preencherem o formulário entram no radar e podem ser chamados em ciclos futuros, 
                        mesmo que não sejam selecionados imediatamente.
                    </p>
                </div>

                <!-- Botão de voltar -->
                <div class="mt-8 sm:mt-10">
                    <a 
                        href="{{ route('public.prospects.show') }}"
                        class="inline-flex items-center justify-center px-6 sm:px-8 py-3 sm:py-4 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-semibold text-base sm:text-lg rounded-xl hover:from-blue-700 hover:to-blue-800 focus:outline-none focus:ring-4 focus:ring-blue-300 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all duration-200"
                    >
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Enviar outra manifestação
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Footer Info -->
        <div class="mt-6 sm:mt-8 text-center">
            <p class="text-xs sm:text-sm text-gray-500">
                Seus dados estão seguros e serão usados apenas para fins de curadoria e contato.
            </p>
        </div>
    </div>
</div>
@endsection
