<x-app-layout>
    <x-slot name="page-title">Relatórios</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Relatórios</li>
    </x-slot>

    <div class="space-y-6" x-data="reportsPage()">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">Relatórios</h1>
        </div>

        <!-- Grid de Cards de Relatórios -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Card: Tempo Médio de Publicação -->
            <x-card>
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Tempo Médio</h3>
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div x-show="loadingAvgTime" class="text-center py-4">
                    <div class="inline-block animate-spin rounded-full h-6 w-6 border-b-2 border-blue-600"></div>
                </div>
                <div x-show="!loadingAvgTime && avgTimeData" style="display: none;">
                    <p class="text-3xl font-bold text-gray-900 mb-2" x-text="avgTimeData.average_days ? Math.round(avgTimeData.average_days) + ' dias' : '—'"></p>
                    <p class="text-sm text-gray-600">Gravação → Publicação</p>
                </div>
                <div x-show="!loadingAvgTime && !avgTimeData" class="text-sm text-gray-500" style="display: none;">
                    Sem dados suficientes
                </div>
            </x-card>

            <!-- Card: Temas Mais Recorrentes -->
            <x-card>
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Temas Mais Recorrentes</h3>
                    <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                </div>
                <div x-show="loadingTopThemes" class="text-center py-4">
                    <div class="inline-block animate-spin rounded-full h-6 w-6 border-b-2 border-green-600"></div>
                </div>
                <div x-show="!loadingTopThemes && topThemes.length > 0" class="space-y-2" style="display: none;">
                    <template x-for="(theme, index) in topThemes.slice(0, 5)" :key="theme.id">
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-700" x-text="theme.name"></span>
                            <span class="font-semibold text-gray-900" x-text="theme.episodes_count"></span>
                        </div>
                    </template>
                    <a 
                        href="{{ route('episodes.index') }}?filter=themes"
                        class="block mt-3 text-sm text-blue-600 hover:text-blue-800 font-medium"
                    >
                        Ver todos →
                    </a>
                </div>
                <div x-show="!loadingTopThemes && topThemes.length === 0" class="text-sm text-gray-500" style="display: none;">
                    Nenhum tema encontrado
                </div>
            </x-card>

            <!-- Card: Convidados Mais Frequentes -->
            <x-card>
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Convidados Mais Frequentes</h3>
                    <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <div x-show="loadingTopGuests" class="text-center py-4">
                    <div class="inline-block animate-spin rounded-full h-6 w-6 border-b-2 border-purple-600"></div>
                </div>
                <div x-show="!loadingTopGuests && topGuests.length > 0" class="space-y-2" style="display: none;">
                    <template x-for="(guest, index) in topGuests.slice(0, 5)" :key="guest.id">
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-700" x-text="guest.name"></span>
                            <span class="font-semibold text-gray-900" x-text="guest.episodes_count"></span>
                        </div>
                    </template>
                    <a 
                        href="{{ route('guests.index') }}"
                        class="block mt-3 text-sm text-blue-600 hover:text-blue-800 font-medium"
                    >
                        Ver todos →
                    </a>
                </div>
                <div x-show="!loadingTopGuests && topGuests.length === 0" class="text-sm text-gray-500" style="display: none;">
                    Nenhum convidado encontrado
                </div>
            </x-card>

            <!-- Card: Episódios por Status -->
            <x-card class="md:col-span-2 lg:col-span-3">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Episódios por Status</h3>
                    <svg class="w-8 h-8 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <div x-show="loadingStatuses" class="text-center py-4">
                    <div class="inline-block animate-spin rounded-full h-6 w-6 border-b-2 border-orange-600"></div>
                </div>
                <div x-show="!loadingStatuses && episodesByStatus.length > 0" class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4" style="display: none;">
                    <template x-for="statusItem in episodesByStatus" :key="statusItem.status">
                        <div class="text-center p-3 bg-gray-50 rounded-lg">
                            <span 
                                x-bind:class="{
                                    'bg-gray-100 text-gray-800': statusItem.status === 'pauta',
                                    'bg-blue-100 text-blue-800': statusItem.status === 'gravacao' || statusItem.status === 'agendado',
                                    'bg-yellow-100 text-yellow-800': statusItem.status === 'edicao' || statusItem.status === 'revisao',
                                    'bg-green-100 text-green-800': statusItem.status === 'publicado'
                                }"
                                class="inline-flex items-center font-medium rounded px-2.5 py-0.5 text-sm mb-2"
                                x-text="getStatusLabel(statusItem.status)"
                            ></span>
                            <p class="text-2xl font-bold text-gray-900 mt-2" x-text="statusItem.count"></p>
                        </div>
                    </template>
                </div>
                <div x-show="!loadingStatuses && episodesByStatus.length === 0" class="text-sm text-gray-500 text-center py-4" style="display: none;">
                    Nenhum episódio encontrado
                </div>
            </x-card>
        </div>
    </div>

    @push('scripts')
    <script>
        function reportsPage() {
            return {
                loadingAvgTime: true,
                loadingTopThemes: true,
                loadingTopGuests: true,
                loadingStatuses: true,
                avgTimeData: null,
                topThemes: [],
                topGuests: [],
                episodesByStatus: [],
                
                async init() {
                    await Promise.all([
                        this.loadAvgTime(),
                        this.loadTopThemes(),
                        this.loadTopGuests(),
                        this.loadEpisodesByStatus(),
                    ]);
                },
                
                async loadAvgTime() {
                    this.loadingAvgTime = true;
                    try {
                        const response = await window.apiFetch('/api/reports/average-publish-time');
                        this.avgTimeData = response.data || null;
                    } catch (error) {
                        console.error('Erro ao carregar tempo médio:', error);
                    } finally {
                        this.loadingAvgTime = false;
                    }
                },
                
                async loadTopThemes() {
                    this.loadingTopThemes = true;
                    try {
                        const response = await window.apiFetch('/api/reports/top-themes');
                        this.topThemes = response.data || [];
                    } catch (error) {
                        console.error('Erro ao carregar temas:', error);
                    } finally {
                        this.loadingTopThemes = false;
                    }
                },
                
                async loadTopGuests() {
                    this.loadingTopGuests = true;
                    try {
                        const response = await window.apiFetch('/api/reports/top-guests');
                        this.topGuests = response.data || [];
                    } catch (error) {
                        console.error('Erro ao carregar convidados:', error);
                    } finally {
                        this.loadingTopGuests = false;
                    }
                },
                
                async loadEpisodesByStatus() {
                    this.loadingStatuses = true;
                    try {
                        const response = await window.apiFetch('/api/reports/episodes-by-status');
                        this.episodesByStatus = response.data || [];
                    } catch (error) {
                        console.error('Erro ao carregar status:', error);
                    } finally {
                        this.loadingStatuses = false;
                    }
                },
                
                getStatusLabel(status) {
                    const statusMap = {
                        'pauta': 'Pauta',
                        'gravacao': 'Gravação',
                        'edicao': 'Edição',
                        'revisao': 'Revisão',
                        'agendado': 'Agendado',
                        'publicado': 'Publicado',
                    };
                    return statusMap[status] || status;
                }
            }
        }
    </script>
    @endpush
</x-app-layout>
