<x-app-layout>
    <x-slot name="page-title">Novo Tema</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li><a href="{{ route('themes.index') }}" class="hover:text-gray-900">Temas</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Novo</li>
    </x-slot>

    <div class="space-y-6" x-data="themeForm()">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">Novo Tema</h1>
        </div>

        <x-card>
            <form @submit.prevent="submitForm" class="space-y-6">
                <!-- Nome -->
                <div>
                    <x-form.input 
                        label="Nome"
                        name="name"
                        x-model="form.name"
                        required
                        :error="$errors->first('name')"
                    />
                </div>

                <!-- Descrição -->
                <div>
                    <x-form.textarea 
                        label="Descrição"
                        name="description"
                        x-model="form.description"
                        rows="4"
                        :error="$errors->first('description')"
                    />
                </div>

                <!-- Botões -->
                <div class="flex justify-end gap-3">
                    <a 
                        href="{{ route('themes.index') }}"
                        class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100"
                    >
                        Cancelar
                    </a>
                    <button 
                        type="submit"
                        :disabled="submitting"
                        class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700 disabled:opacity-50"
                    >
                        <span x-show="!submitting">Criar Tema</span>
                        <span x-show="submitting" style="display: none;">Criando...</span>
                    </button>
                </div>
            </form>
        </x-card>
    </div>

    @push('scripts')
    <script>
        function themeForm() {
            return {
                submitting: false,
                form: {
                    name: '',
                    description: '',
                },
                errors: {},
                
                async submitForm() {
                    this.submitting = true;
                    window.clearFormErrors();
                    
                    try {
                        const response = await window.apiFetch('/api/themes', {
                            method: 'POST',
                            body: this.form,
                        });
                        
                        window.showToast('Tema criado com sucesso!', 'success');
                        window.location.href = '/themes';
                    } catch (error) {
                        console.error('Erro ao criar tema:', error);
                        if (error.errors) {
                            this.errors = error.errors;
                            window.mapApiErrorsToFields(error.errors, document.querySelector('[x-data*="themeForm"]'));
                            window.showToast('Corrija os erros do formulário', 'error');
                        } else {
                            window.showToast('Erro ao criar tema', 'error');
                        }
                    } finally {
                        this.submitting = false;
                    }
                }
            }
        }
    </script>
    @endpush
</x-app-layout>
