<x-app-layout>
    <x-slot name="page-title">Temas</x-slot>

    <x-slot name="breadcrumbs">
        <li><a href="{{ route('dashboard') }}" class="hover:text-gray-900">Dashboard</a></li>
        <li class="text-gray-500">/</li>
        <li class="text-gray-900">Temas</li>
    </x-slot>

    <div class="space-y-6" x-data="themesList()">
        <!-- Header com CTA -->
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">Temas</h1>
            <a href="{{ route('themes.create') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Novo Tema
            </a>
        </div>

        <!-- Busca -->
        <x-card>
            <div class="flex gap-4">
                <div class="flex-1">
                    <input 
                        type="text"
                        x-model="search"
                        @input.debounce.500ms="loadThemes()"
                        placeholder="Buscar por nome..."
                        class="w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5"
                    >
                </div>
            </div>
        </x-card>

        <!-- Loading State -->
        <div x-show="loading" class="text-center py-12">
            <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-blue-600"></div>
            <p class="mt-2 text-gray-600">Carregando temas...</p>
        </div>

        <!-- Empty State -->
        <x-empty-state 
            x-show="!loading && themes.length === 0"
            title="Nenhum tema encontrado"
            description="Comece criando seu primeiro tema!"
            action-label="Criar Tema"
            action-url="{{ route('themes.create') }}"
            style="display: none;"
        />

        <!-- Grid de Temas -->
        <div x-show="!loading && themes.length > 0" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4" style="display: none;">
            <template x-for="theme in themes" :key="theme.id">
                <x-card>
                    <div class="flex items-start justify-between mb-3">
                        <h3 class="text-lg font-semibold text-gray-900" x-text="theme.name"></h3>
                        <a 
                            :href="`/themes/${theme.id}/edit`"
                            class="text-blue-600 hover:text-blue-800"
                            title="Editar"
                        >
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                            </svg>
                        </a>
                    </div>
                    <template x-if="theme.description">
                        <p class="text-sm text-gray-600 mb-3" x-text="theme.description"></p>
                    </template>
                    <div class="flex items-center text-sm text-gray-500">
                        <span x-text="theme.episodes_count || 0"></span>
                        <span class="ml-1">episódio(s)</span>
                    </div>
                </x-card>
            </template>
        </div>
    </div>

    @push('scripts')
    <script>
        function themesList() {
            return {
                loading: true,
                themes: [],
                search: '',
                
                init() {
                    this.loadThemes();
                },
                
                async loadThemes() {
                    this.loading = true;
                    
                    try {
                        const params = new URLSearchParams();
                        
                        if (this.search) {
                            params.append('q', this.search);
                        }
                        
                        const response = await window.apiFetch(`/api/themes?${params.toString()}`);
                        
                        if (response.data && Array.isArray(response.data)) {
                            this.themes = response.data;
                        } else {
                            this.themes = [];
                        }
                    } catch (error) {
                        console.error('Erro ao carregar temas:', error);
                        window.showToast('Erro ao carregar temas', 'error');
                    } finally {
                        this.loading = false;
                    }
                }
            }
        }
    </script>
    @endpush
</x-app-layout>
