<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Gestor Editorial - Sistema de Gestão de Podcast</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased bg-gray-50 min-h-screen">
        <!-- Navigation -->
        <nav class="w-full px-6 py-4 border-b border-gray-200 bg-white sticky top-0 z-50">
            <div class="max-w-7xl mx-auto flex items-center justify-center">
                <a href="/" class="flex items-center">
                    <img 
                        src="{{ asset('images/logomarcas/EMPATHEIA_LOGO-TRANSPARENTE.png') }}" 
                        alt="Empatheia Logo" 
                        class="h-12 w-auto"
                    >
                </a>
            </div>
        </nav>

        <!-- Hero Section -->
        <main class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="text-center py-16 lg:py-24">
                <h2 class="text-5xl lg:text-6xl font-bold text-gray-900 mb-4 tracking-tight">
                    Sistema de Gestão Editorial
                </h2>
                <p class="text-xl text-gray-600 mb-8 max-w-3xl mx-auto">
                    Organize, acompanhe e gerencie todo o fluxo de produção dos episódios do seu podcast — da pauta à publicação.
                </p>
                
                @guest
                <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                    <a
                        href="{{ route('login') }}"
                        class="inline-flex items-center px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors font-medium shadow-sm"
                    >
                        Acessar Sistema
                    </a>
                    <a
                        href="{{ route('public.prospects.show') }}"
                        class="inline-flex items-center px-6 py-3 bg-white text-gray-900 border border-gray-300 rounded-lg hover:bg-gray-100 transition-colors font-medium"
                    >
                        Manifestar Interesse
                    </a>
                </div>
                @endguest
            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-20">
                <!-- Feature 1 -->
                <div class="bg-white rounded-lg shadow p-6 hover:shadow-md transition-shadow">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Gestão de Episódios</h3>
                    <p class="text-gray-600 text-sm">
                        Controle completo do pipeline de produção, desde a pauta até a publicação, com acompanhamento por status.
                    </p>
                </div>

                <!-- Feature 2 -->
                <div class="bg-white rounded-lg shadow p-6 hover:shadow-md transition-shadow">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Calendário Editorial</h3>
                    <p class="text-gray-600 text-sm">
                        Visualize e organize as datas de gravação e publicação em um calendário intuitivo.
                    </p>
                </div>

                <!-- Feature 3 -->
                <div class="bg-white rounded-lg shadow p-6 hover:shadow-md transition-shadow">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Convidados e Temas</h3>
                    <p class="text-gray-600 text-sm">
                        Gerencie convidados, temas abordados e mantenha um histórico completo da curadoria.
                    </p>
                </div>

                <!-- Feature 4 -->
                <div class="bg-white rounded-lg shadow p-6 hover:shadow-md transition-shadow">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Checklist Editorial</h3>
                    <p class="text-gray-600 text-sm">
                        Crie e acompanhe tarefas por episódio, com prazos e responsáveis.
                    </p>
                </div>

                <!-- Feature 5 -->
                <div class="bg-white rounded-lg shadow p-6 hover:shadow-md transition-shadow">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Assets e Links</h3>
                    <p class="text-gray-600 text-sm">
                        Organize links para áudio, vídeo, roteiros, thumbs e outros assets de produção.
                    </p>
                </div>

                <!-- Feature 6 -->
                <div class="bg-white rounded-lg shadow p-6 hover:shadow-md transition-shadow">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Relatórios e Análises</h3>
                    <p class="text-gray-600 text-sm">
                        Visualize métricas, temas mais abordados e tempo médio de produção.
                    </p>
                </div>
            </div>

            <!-- CTA Section -->
            @guest
            <div class="mt-16 mb-20 text-center bg-white rounded-lg shadow p-12">
                <h3 class="text-2xl font-bold text-gray-900 mb-4">
                    Pronto para começar?
                </h3>
                <p class="text-lg text-gray-600 mb-8 max-w-xl mx-auto">
                    Acesse o sistema e comece a organizar a produção editorial do seu podcast de forma profissional.
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                    <a
                        href="{{ route('login') }}"
                        class="inline-flex items-center px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors font-medium shadow-sm"
                    >
                        Fazer Login
                    </a>
                    <a
                        href="{{ route('public.prospects.show') }}"
                        class="inline-flex items-center px-6 py-3 bg-white text-gray-900 border border-gray-300 rounded-lg hover:bg-gray-100 transition-colors font-medium"
                    >
                        Manifestar Interesse
                    </a>
                </div>
            </div>
            @endguest
        </main>

        <!-- Footer -->
        <footer class="border-t border-gray-200 mt-20 py-8 bg-white">
            <div class="max-w-7xl mx-auto px-6 lg:px-8">
                <div class="flex flex-col sm:flex-row items-center justify-between gap-4 text-sm text-gray-600">
                    <p>&copy; {{ date('Y') }} Gestor Editorial. Sistema de gestão para produção de podcasts.</p>
                    <div class="flex items-center gap-6">
                        <a
                            href="{{ route('public.prospects.show') }}"
                            class="text-gray-900 hover:text-blue-600 transition-colors font-medium"
                        >
                            Manifestar Interesse
                        </a>
                        @guest
                            <a
                                href="{{ route('login') }}"
                                class="text-gray-900 hover:text-blue-600 transition-colors font-medium"
                            >
                                Login
                            </a>
                        @endguest
                    </div>
                </div>
            </div>
        </footer>
    </body>
</html>
