<?php

use App\Http\Controllers\EpisodeController;
use App\Http\Controllers\EpisodeTaskController;
use App\Http\Controllers\EpisodeAssetController;
use App\Http\Controllers\CalendarController;
use App\Http\Controllers\GuestController;
use App\Http\Controllers\ThemeController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ConsoleLogController;
use Illuminate\Support\Facades\Route;

// Usa autenticação via sessão (mesmo que web)
// Precisa do middleware 'web' para compartilhar sessão e CSRF
Route::middleware(['web', 'auth'])->group(function () {
    // Rotas de Episódios
    Route::get('/episodes', [EpisodeController::class, 'index']);
    Route::post('/episodes', [EpisodeController::class, 'store']);
    Route::get('/episodes/{episode}', [EpisodeController::class, 'show']);
    Route::put('/episodes/{episode}', [EpisodeController::class, 'update']);
    Route::patch('/episodes/{episode}', [EpisodeController::class, 'update']);
    Route::delete('/episodes/{episode}', [EpisodeController::class, 'destroy']);
    
    Route::post('/episodes/{episode}/transition', [EpisodeController::class, 'advanceStatus']);
    Route::get('/episodes/{episode}/allowed-transitions', [EpisodeController::class, 'allowedTransitions']);
    
    // Rotas de Tarefas
    Route::get('/episodes/{episode}/tasks', [EpisodeTaskController::class, 'index']);
    Route::post('/episodes/{episode}/tasks', [EpisodeTaskController::class, 'store']);
    Route::patch('/episodes/{episode}/tasks/{task}', [EpisodeTaskController::class, 'update']);
    Route::delete('/episodes/{episode}/tasks/{task}', [EpisodeTaskController::class, 'destroy']);
    
    // Rotas de Assets
    Route::get('/episodes/{episode}/assets', [EpisodeAssetController::class, 'index']);
    Route::post('/episodes/{episode}/assets', [EpisodeAssetController::class, 'store']);
    Route::patch('/episodes/{episode}/assets/{asset}', [EpisodeAssetController::class, 'update']);
    Route::delete('/episodes/{episode}/assets/{asset}', [EpisodeAssetController::class, 'destroy']);
    
    // Rotas de Calendário
    Route::get('/calendar', [CalendarController::class, 'index']);
    
    // Rotas de Convidados
    Route::get('/guests', [GuestController::class, 'index']);
    Route::post('/guests', [GuestController::class, 'store']);
    Route::get('/guests/{guest}', [GuestController::class, 'show']);
    Route::put('/guests/{guest}', [GuestController::class, 'update']);
    Route::patch('/guests/{guest}', [GuestController::class, 'update']);
    Route::delete('/guests/{guest}', [GuestController::class, 'destroy']);
    
    // Rotas de Temas
    Route::get('/themes', [ThemeController::class, 'index']);
    Route::post('/themes', [ThemeController::class, 'store']);
    Route::get('/themes/{theme}', [ThemeController::class, 'show']);
    Route::put('/themes/{theme}', [ThemeController::class, 'update']);
    Route::patch('/themes/{theme}', [ThemeController::class, 'update']);
    Route::delete('/themes/{theme}', [ThemeController::class, 'destroy']);
    
    // Rotas de Relatórios
    Route::get('/reports/top-themes', [ReportController::class, 'topThemes']);
    Route::get('/reports/average-publish-time', [ReportController::class, 'averagePublishTime']);
    Route::get('/reports/episodes-by-status', [ReportController::class, 'episodesByStatus']);
    Route::get('/reports/top-guests', [ReportController::class, 'topGuests']);
    
    // Rotas administrativas de Console Logs
    Route::get('/console-logs', [ConsoleLogController::class, 'index']);
    Route::get('/console-logs/stats', [ConsoleLogController::class, 'stats']);
    Route::get('/console-logs/{consoleLog}', [ConsoleLogController::class, 'show']);
    Route::patch('/console-logs/{consoleLog}/resolve', [ConsoleLogController::class, 'toggleResolved']);
    Route::delete('/console-logs/{consoleLog}', [ConsoleLogController::class, 'destroy']);
});

// Rotas públicas para receber logs (sem autenticação obrigatória para capturar erros antes do login)
// Nota: Laravel adiciona automaticamente o prefixo /api às rotas em api.php
Route::middleware(['web'])->group(function () {
    Route::post('/console-logs', [ConsoleLogController::class, 'store']);
    Route::post('/console-logs/batch', [ConsoleLogController::class, 'storeBatch']); // Endpoint otimizado para batch
});
