<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CalendarController;
use App\Http\Controllers\EpisodeController;
use App\Http\Controllers\GuestController;
use App\Http\Controllers\ThemeController;
use App\Http\Controllers\EpisodeTaskController;
use App\Http\Controllers\EpisodeAssetController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ConsoleLogController;
use App\Http\Controllers\PublicProspectController;
use App\Http\Controllers\ProspectController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    // Se o usuário já estiver autenticado, redireciona para o dashboard
    if (auth()->check()) {
        return redirect()->route('dashboard');
    }
    return view('welcome');
});

// Rotas públicas - Formulário de manifestação de interesse
Route::get('manifestar-interesse', [PublicProspectController::class, 'show'])
    ->name('public.prospects.show');
Route::post('manifestar-interesse', [PublicProspectController::class, 'store'])
    ->name('public.prospects.store');
Route::get('manifestar-interesse/obrigado', [PublicProspectController::class, 'thanks'])
    ->name('public.prospects.thanks');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/components-test', function () {
        return view('components-test');
    })->name('components-test');
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Rotas do calendário
    Route::get('/calendar', [CalendarController::class, 'index'])->name('calendar.index');
    
    // Rotas de Episódios
    Route::resource('episodes', EpisodeController::class);
    Route::post('/episodes/{episode}/advance-status', [EpisodeController::class, 'advanceStatus'])->name('episodes.advance-status');
    Route::get('/episodes/{episode}/allowed-transitions', [EpisodeController::class, 'allowedTransitions'])->name('episodes.allowed-transitions');
    
    // Rotas de Tarefas (nested em episódios)
    Route::get('/episodes/{episode}/tasks', [EpisodeTaskController::class, 'index'])->name('episodes.tasks.index');
    Route::post('/episodes/{episode}/tasks', [EpisodeTaskController::class, 'store'])->name('episodes.tasks.store');
    Route::patch('/episodes/{episode}/tasks/{task}', [EpisodeTaskController::class, 'update'])->name('episodes.tasks.update');
    Route::delete('/episodes/{episode}/tasks/{task}', [EpisodeTaskController::class, 'destroy'])->name('episodes.tasks.destroy');
    
    // Rotas de Assets (nested em episódios)
    Route::get('/episodes/{episode}/assets', [EpisodeAssetController::class, 'index'])->name('episodes.assets.index');
    Route::post('/episodes/{episode}/assets', [EpisodeAssetController::class, 'store'])->name('episodes.assets.store');
    Route::patch('/episodes/{episode}/assets/{asset}', [EpisodeAssetController::class, 'update'])->name('episodes.assets.update');
    Route::delete('/episodes/{episode}/assets/{asset}', [EpisodeAssetController::class, 'destroy'])->name('episodes.assets.destroy');
    
    // Rotas de Convidados
    Route::resource('guests', GuestController::class);
    
    // Rotas de Prospects (Curadoria)
    Route::resource('prospects', ProspectController::class);
    Route::post('/prospects/{prospect}/approve', [ProspectController::class, 'approve'])->name('prospects.approve');
    Route::post('/prospects/{prospect}/reject', [ProspectController::class, 'reject'])->name('prospects.reject');
    
    // Rotas de Temas
    Route::resource('themes', ThemeController::class);
    
    // Rotas de Relatórios
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [ReportController::class, 'index'])->name('index');
        Route::get('/top-themes', [ReportController::class, 'topThemes'])->name('top-themes');
        Route::get('/average-publish-time', [ReportController::class, 'averagePublishTime'])->name('average-publish-time');
        Route::get('/episodes-by-status', [ReportController::class, 'episodesByStatus'])->name('episodes-by-status');
        Route::get('/top-guests', [ReportController::class, 'topGuests'])->name('top-guests');
    });

    // Rotas de Console Logs (apenas para admins)
    Route::middleware('role:admin')->prefix('console-logs')->name('console-logs.')->group(function () {
        Route::get('/', [ConsoleLogController::class, 'indexPage'])->name('index');
    });
});

require __DIR__.'/auth.php';
