Entidades do Sistema — Mapa Geral

Vou listar e categorizar por domínio, já pensando em manutenção, evolução e leitura estratégica do projeto.

1️⃣ Núcleo Editorial (Core do Produto)

Essas entidades existem porque o podcast existe. Sem elas, não há sistema.

🎧 Episódio (episodes)

Categoria: Conteúdo Editorial
Papel: Unidade central de produção e publicação.

Relaciona-se com praticamente tudo:

convidados

temas

tarefas

assets

usuários

Campos-chave:

título, slug

status editorial

datas (gravação / publicação)

descrição

links de publicação

É o hub do domínio editorial.

👤 Convidado (guests)

Categoria: Ativo de Relacionamento
Papel: Pessoas que geram valor de conteúdo e rede.

Características:

reutilizável em vários episódios

carrega histórico

pode gerar inteligência de relacionamento no futuro

Campos típicos:

nome

cargo / atuação

organização

bio curta

links externos

🧠 Tema (themes)

Categoria: Ativo Estratégico de Conteúdo
Papel: Representa os assuntos abordados no podcast.

Características:

N:N com episódios

permite análise de recorrência

ajuda na curadoria editorial

Exemplos:

Ecossistemas de Inovação

GovTech

Smart Cities

Empreendedorismo

Tecnologia & Sociedade

🔗 Episódio ↔ Convidado (episode_guests)

Categoria: Entidade de Relacionamento
Papel: Conecta episódios e convidados (N:N).

Campos comuns:

episode_id

guest_id

papel (host, co-host, convidado — opcional)

🔗 Episódio ↔ Tema (episode_themes)

Categoria: Entidade de Relacionamento
Papel: Conecta episódios e temas (N:N).

Campos comuns:

episode_id

theme_id

2️⃣ Operação Editorial (Execução do Dia a Dia)

Essas entidades garantem que o episódio saia do papel.

✅ Tarefa Editorial (episode_tasks)

Categoria: Execução / Workflow
Papel: Checklist operacional por episódio.

Exemplos de tarefas:

roteiro

confirmação do convidado

gravação

edição

cortes

thumb

publicação

divulgação

Campos-chave:

título

status (feito / não feito)

prazo

responsável

📁 Asset (episode_assets)

Categoria: Infraestrutura de Produção
Papel: Centralizar links e materiais do episódio.

Tipos:

áudio

vídeo

thumb

roteiro

cortes

drive

outros

Decisão estratégica: linkar, não armazenar.

3️⃣ Governança & Acesso

Essas entidades controlam quem faz o quê.

👥 Usuário (users)

Categoria: Governança Operacional
Papel: Controle de acesso ao sistema.

Perfis:

admin

editor

Campos típicos:

nome

email

senha (hash)

role

4️⃣ Apoio Editorial 

🏢 Organização (organizations) 

Categoria: Contexto Institucional
Papel: Vincular convidados a organizações.

Exemplo:

convidado representa uma startup, hub, empresa, governo

💬 Comentários / Notas (episode_notes)

Categoria: Colaboração
Papel: Registrar observações internas sobre o episódio.

📊 Métricas Editorial (episode_metrics)

Categoria: Inteligência
Papel: Dados de performance editorial.

Exemplos:

views

plays

engajamento

tempo médio até publicação

5️⃣ Visão Resumida (Mapa Mental)
NÚCLEO
- Episódio
- Convidado
- Tema

RELACIONAMENTOS
- Episódio ↔ Convidado
- Episódio ↔ Tema

OPERAÇÃO
- Tarefa Editorial
- Asset

GOVERNANÇA
- Usuário

EVOLUÇÃO
- Organização
- Notas
- Métricas

A seguir está um **documento-base** (em Markdown) para descrever o **Diagrama ER** do seu sistema editorial do podcast. Ele serve tanto para alinhar time/cliente quanto para orientar implementação no MySQL.

---

# Documento do Diagrama ER

**Projeto:** Podcast Vale do Pinhão — Editorial Manager
**Stack:** PHP + MySQL
**Objetivo:** Modelar, em nível de dados, o fluxo editorial (episódios), com governança, convidados, temas, checklist e assets.

---

## 1) Visão Geral do Modelo

O modelo é centrado em **Episódios** como entidade principal. A partir dela, o sistema organiza:

* **Convidados** (entidade reutilizável com histórico)
* **Temas** (curadoria editorial e inteligência de conteúdo)
* **Tarefas** (workflow operacional por episódio)
* **Assets** (materiais e links de produção por episódio)
* **Usuários** (controle de acesso e rastreabilidade básica)

O desenho prioriza:

* **simplicidade de implementação**
* **consistência relacional**
* **capacidade de crescimento** (roadmap) sem retrabalho estrutural

---

## 2) Entidades do Modelo

### 2.1 Usuário (`users`)

**Papel:** governança e autenticação.

**Atributos principais**

* `id` (PK)
* `name`
* `email` (UNIQUE)
* `password` (hash gerenciado pelo Laravel)
* `role` (admin/editor)
* `created_at`, `updated_at`

**Regras**

* Email único por usuário.
* `role` define permissões.

---

### 2.2 Episódio (`episodes`)

**Papel:** entidade central do pipeline editorial.

**Atributos principais**

* `id` (PK)
* `title`
* `slug` (UNIQUE)
* `record_date` (data de gravação)
* `publish_date` (data de publicação)
* `status` (pauta/gravacao/edicao/revisao/agendado/publicado)
* `description`
* `tags` (string simples no MVP)
* `youtube_url`, `spotify_url`
* `created_by` (FK -> users.id)
* `created_at`, `updated_at`

**Regras**

* `slug` único para URL amigável.
* `created_by` pode ser nulo (se usuário for removido, preserva episódio).
* `status` controla etapa do funil editorial.

---

### 2.3 Convidado (`guests`)

**Papel:** ativo de relacionamento e curadoria de rede.

**Atributos principais**

* `id` (PK)
* `name`
* `role_title` (cargo/atuação)
* `organization` (organização como texto — mantido para compatibilidade)
* `organization_id` (FK -> organizations.id, opcional)
* `bio_short`
* `linkedin_url`, `website_url` (opcional)
* `created_at`, `updated_at`

**Regras**

* Convidado é reutilizável em múltiplos episódios.
* Nome não precisa ser único (pode haver homônimos — se quiser, depois adiciona "external_id" ou normalização).
* `organization_id` permite vincular a uma organização estruturada, enquanto `organization` (texto) mantém flexibilidade no MVP.

---

### 2.4 Tema (`themes`)

**Papel:** ativo estratégico de conteúdo.

**Atributos principais**

* `id` (PK)
* `name` (UNIQUE recomendado)
* `description` (opcional)
* `created_at`

**Regras**

* Ideal manter `name` único para evitar duplicidades (“GovTech” vs “Gov Tech”).

---

### 2.5 Relação Episódio ↔ Convidado (`episode_guests`)

**Tipo:** entidade associativa (N:N)

**Papel:** registrar quais convidados participaram de quais episódios.

**Atributos principais**

* `episode_id` (FK -> episodes.id)
* `guest_id` (FK -> guests.id)
* `guest_role` (opcional: host/cohost/convidado)
* PK composta sugerida: (`episode_id`, `guest_id`)

**Regras**

* Um episódio pode ter **0..N** convidados.
* Um convidado pode participar de **0..N** episódios.
* PK composta evita “mesmo convidado duplicado no mesmo episódio”.

---

### 2.6 Relação Episódio ↔ Tema (`episode_themes`)

**Tipo:** entidade associativa (N:N)

**Papel:** registrar temas abordados em cada episódio.

**Atributos principais**

* `episode_id` (FK -> episodes.id)
* `theme_id` (FK -> themes.id)
* PK composta sugerida: (`episode_id`, `theme_id`)

**Regras**

* Um episódio pode ter **0..N** temas.
* Um tema pode aparecer em **0..N** episódios.

---

### 2.7 Tarefa Editorial (`episode_tasks`)

**Papel:** checklist operacional para garantir execução.

**Atributos principais**

* `id` (PK)
* `episode_id` (FK -> episodes.id)
* `title`
* `is_done` (0/1)
* `due_date` (opcional)
* `assigned_to` (FK -> users.id, opcional)
* `created_at`

**Regras**

* Cada tarefa pertence a **um** episódio.
* Um episódio tem **0..N** tarefas.
* `assigned_to` é opcional para manter MVP leve.

---

### 2.8 Asset (`episode_assets`)

**Papel:** central de materiais e links de produção por episódio.

**Atributos principais**

* `id` (PK)
* `episode_id` (FK -> episodes.id)
* `asset_type` (audio/video/thumb/roteiro/cortes/drive/outros)
* `label` (opcional)
* `url`
* `created_at`

**Regras**

* Cada asset pertence a **um** episódio.
* Um episódio tem **0..N** assets.
* Estratégia: **armazenar links**, não arquivos.

---

### 2.9 Organização (`organizations`)

**Papel:** contexto institucional para vincular convidados a organizações.

**Atributos principais**

* `id` (PK)
* `name`
* `type` (startup/hub/empresa/governo/ong/etc)
* `description` (opcional)
* `website_url`, `linkedin_url` (opcional)
* `created_at`, `updated_at`

**Regras**

* Uma organização pode ter **0..N** convidados vinculados.
* Permite análise de relacionamento institucional.

---

### 2.10 Nota Editorial (`episode_notes`)

**Papel:** comentários internos e observações sobre episódios.

**Atributos principais**

* `id` (PK)
* `episode_id` (FK -> episodes.id)
* `note` (texto do comentário)
* `created_by` (FK -> users.id, opcional)
* `created_at`, `updated_at`

**Regras**

* Cada nota pertence a **um** episódio.
* Um episódio tem **0..N** notas.
* Permite colaboração e registro de decisões editoriais internas.

---

### 2.11 Métrica Editorial (`episode_metrics`)

**Papel:** dados de performance e inteligência editorial.

**Atributos principais**

* `id` (PK)
* `episode_id` (FK -> episodes.id)
* `views` (visualizações)
* `plays` (reproduções)
* `engagement_rate` (taxa de engajamento em %)
* `avg_time_to_publish_days` (tempo médio até publicação em dias)
* `metric_date` (data da métrica para histórico)
* `created_at`, `updated_at`

**Regras**

* Cada métrica pertence a **um** episódio.
* Um episódio pode ter **0..N** métricas (histórico temporal).
* Permite análise de performance e otimização editorial.

---

## 2.12 Status de Implementação no Laravel

As seguintes entidades já estão modeladas em migrations e models no backend Laravel:

**Núcleo Editorial:**
- `users` — com campo `role` (admin/editor) e métodos `isAdmin()`, `isEditor()`.
- `episodes` — com relações para `users`, `guests`, `themes`, `episode_tasks`, `episode_assets`, `episode_notes`, `episode_metrics`.
- `guests` — convidados reutilizáveis com relação para `organizations`.
- `themes` — temas únicos.
- `episode_guests` — relação N:N entre episódios e convidados (com `guest_role`).
- `episode_themes` — relação N:N entre episódios e temas.

**Operação Editorial:**
- `episode_tasks` — tarefas por episódio com responsável opcional.
- `episode_assets` — assets de produção por episódio (links).

**Apoio Editorial:**
- `organizations` — organizações vinculadas a convidados.
- `episode_notes` — comentários internos por episódio.
- `episode_metrics` — métricas de performance por episódio.

---

## 3) Relacionamentos e Cardinalidade

### 3.1 Usuário (1) — (N) Episódio

* `users.id` → `episodes.created_by`
* **Um usuário** pode criar **vários episódios**
* **Um episódio** é criado por **0 ou 1 usuário** (por regra de deleção “SET NULL”)

### 3.2 Episódio (1) — (N) Tarefa

* `episodes.id` → `episode_tasks.episode_id`

### 3.3 Episódio (1) — (N) Asset

* `episodes.id` → `episode_assets.episode_id`

### 3.4 Episódio (N) — (N) Convidado

* via `episode_guests`

### 3.5 Episódio (N) — (N) Tema

* via `episode_themes`

### 3.6 Organização (1) — (N) Convidado

* `organizations.id` → `guests.organization_id`
* **Uma organização** pode ter **vários convidados**
* **Um convidado** pertence a **0 ou 1 organização** (por regra de deleção "SET NULL")

### 3.7 Episódio (1) — (N) Nota

* `episodes.id` → `episode_notes.episode_id`
* **Um episódio** pode ter **várias notas**
* **Uma nota** pertence a **um episódio**

### 3.8 Episódio (1) — (N) Métrica

* `episodes.id` → `episode_metrics.episode_id`
* **Um episódio** pode ter **várias métricas** (histórico temporal)
* **Uma métrica** pertence a **um episódio**

### 3.9 Usuário (1) — (N) Nota

* `users.id` → `episode_notes.created_by`
* **Um usuário** pode criar **várias notas**
* **Uma nota** é criada por **0 ou 1 usuário** (por regra de deleção "SET NULL")

---

## 4) Regras de Integridade e Deleção

Recomendações para manter o banco “à prova de caos”:

* Deletar **episódio**:

  * remove tarefas, assets, notas e métricas (CASCADE)
  * remove vínculos em `episode_guests` e `episode_themes` (CASCADE)
* Deletar **usuário**:

  * episódios permanecem (`created_by` vira NULL)
  * tarefas atribuídas podem virar NULL (SET NULL)
* Deletar **convidado**:

  * remove apenas o vínculo no join (`episode_guests`) (CASCADE)
  * episódios seguem existindo
* Deletar **tema**:

  * remove vínculo em `episode_themes` (CASCADE)

* Deletar **organização**:

  * convidados permanecem (`organization_id` vira NULL)
  * histórico de participação em episódios é preservado

* Deletar **episódio**:

  * remove notas e métricas (CASCADE)
  * remove vínculos em `episode_guests` e `episode_themes` (CASCADE)
  * remove tarefas e assets (CASCADE)

---

## 5) Observações de Design

* **`tags` em episódios**: no MVP pode ser string (rápido).
  Evolução: criar `tags` e `episode_tags` para normalização.
* **`guest_names` como texto**: evitar. Melhor usar `guests` + `episode_guests`.
  Isso abre:

  * histórico por convidado
  * análises editoriais e relatórios
* **`themes` como entidade**: evita “tema duplicado por digitação”.

---

## 6) Evoluções Previstas (Roadmap de ER)

Quando o produto amadurecer, adicionar:

* ✅ `organizations` (e relacionar `guests.organization_id`) — **IMPLEMENTADO**
* ✅ `episode_notes` (comentários internos e decisões editoriais) — **IMPLEMENTADO**
* ✅ `episode_metrics` (views/plays/engajamento) — **IMPLEMENTADO**
* `audit_log` (rastreabilidade: quem mudou status, quando)
* `media_posts` (checklist de divulgação por canal)
* `tags` e `episode_tags` (normalização de tags em vez de string simples)
* `episode_status_history` (histórico de mudanças de status)

---


