# Plano de Execução — Gestor Editorial

## Status Atual do Projeto

✅ **CONCLUÍDO:**
- Ambiente Docker configurado (PHP 8.4 + MySQL 8.0)
- Laravel 12 instalado e funcionando
- Todas as migrations criadas e executadas
- Models com relacionamentos configurados
- Estrutura de banco de dados completa
- **Calendário implementado** (CalendarService, CalendarController, DTO, rotas, índices)

📋 **EM ANDAMENTO:**
- Seeders e dados iniciais
- Autenticação e autorização

⏳ **PRÓXIMOS PASSOS:**
- Controllers e rotas
- Views/Interface
- Validações e regras de negócio

---

## 1) Congelar o escopo do MVP (pra não virar novela)

### MVP obrigatório ✅ IMPLEMENTADO

- ✅ Episodes
- ✅ Guests
- ✅ Themes
- ✅ Episode_Guests (N:N)
- ✅ Episode_Themes (N:N)
- ✅ Tasks (episode_tasks)
- ✅ Assets (episode_assets)
- ✅ Users (estrutura pronta, falta autenticação)

### MVP opcional ✅ IMPLEMENTADO (bonus!)

- ✅ Organizations
- ✅ Notes (episode_notes)
- ✅ Metrics (episode_metrics)

**Regra de ouro:** primeiro rodar, depois "ficar inteligente".

## 2) Schema e Seeds

### ✅ Schema SQL — CONCLUÍDO

**Status:** Todas as migrations criadas e executadas no Laravel.

**Estrutura implementada:**
- ✅ PKs, FKs, CASCADE/SET NULL configurados
- ✅ Índices implícitos (slug unique, foreign keys)
- ✅ utf8mb4 (padrão Laravel)
- ✅ Todas as tabelas: users, episodes, guests, themes, organizations, episode_guests, episode_themes, episode_tasks, episode_assets, episode_notes, episode_metrics

**Próxima ação:**
- [ ] Criar seeder para usuário admin padrão
- [ ] Criar seeder para temas iniciais (GovTech, Smart Cities, Ecossistemas de Inovação, etc.)
- [ ] Criar seeder para template de tarefas padrão (opcional)
- [ ] Documentar schema completo em `/docs/schema.md` (opcional)

## 3) Contrato de UX (telas mínimas) e rotas

### Telas do MVP — A IMPLEMENTAR

**Autenticação:**
- [ ] Login/Logout
- [ ] Middleware de autenticação
- [ ] Middleware de autorização (admin/editor)

**Dashboard:**
- [ ] Cards por status (pauta, gravação, edição, revisão, agendado, publicado)
- [ ] Lista de episódios recentes (últimos 10)
- [ ] Estatísticas rápidas (total por status)

**Episódios:**
- [ ] Lista de episódios com filtros (status, tema, convidado)
- [ ] CRUD Episódio completo
  - [ ] Criar/Editar com seleção de convidados (multi-select)
  - [ ] Seleção de temas (multi-select)
  - [ ] Checklist de tarefas na mesma tela
  - [ ] Gestão de assets na mesma tela (ou abas)
  - [ ] Botão "Avançar status" com validações

**Gestão:**
- [ ] CRUD Convidados
- [ ] CRUD Temas
- [ ] CRUD Organizações (opcional, mas já implementado)

**Se você fizer isso bem feito, o sistema vira central operacional da editoração.**

## 4) Implementar o "workflow que se vende sozinho"

### Features estratégicas — A IMPLEMENTAR

**Checklist padrão automático (Template + Observer):**

**Arquitetura recomendada:**
- [ ] Criar array de configuração `config/episode_tasks.php` com template padrão:
  ```php
  return [
      'default_tasks' => [
          ['title' => 'Roteiro', 'is_critical' => true],
          ['title' => 'Confirmação do convidado', 'is_critical' => true],
          ['title' => 'Gravação', 'is_critical' => true],
          ['title' => 'Edição', 'is_critical' => false],
          ['title' => 'Cortes', 'is_critical' => false],
          ['title' => 'Thumb', 'is_critical' => false],
          ['title' => 'Publicação', 'is_critical' => true],
          ['title' => 'Divulgação', 'is_critical' => false],
      ],
  ];
  ```
- [ ] Criar `EpisodeObserver@created` que:
  - [ ] Lê o template de `config/episode_tasks.php`
  - [ ] Cria `EpisodeTask` para cada item do template
  - [ ] Associa ao episódio recém-criado
- [ ] (Futuro) Criar tabela `task_templates` se quiser admin ajustar depois

**Vantagens:**
- ✅ Padrão replicável e configurável
- ✅ Admin consegue ajustar depois (quando quiser)
- ✅ Código limpo e testável

**Botão "Avançar status" — Máquina de Estados Formalizada:**

**Arquitetura:**
- [ ] Criar `EpisodeStatusService` com máquina de estados:
  ```php
  class EpisodeStatusService {
      // Transições permitidas
      private const ALLOWED_TRANSITIONS = [
          'pauta' => ['gravacao'],
          'gravacao' => ['edicao'],
          'edicao' => ['revisao'],
          'revisao' => ['agendado'],
          'agendado' => ['publicado'],
      ];
      
      // Regras de validação por transição
      private const VALIDATION_RULES = [
          'agendado' => [
              'requires' => ['youtube_url', 'spotify_url'], // pelo menos um
              'critical_tasks_done' => true,
          ],
      ];
  }
  ```

**Implementação:**
- [ ] Método `canTransition($from, $to, $episode)`: verifica se transição é permitida
- [ ] Método `validateTransition($from, $to, $episode)`: valida regras específicas
- [ ] Método `transition($episode, $to)`: executa transição com validação
- [ ] Mensagens de bloqueio claras:
  - [ ] "Não é possível avançar: falta preencher YouTube ou Spotify"
  - [ ] "Não é possível avançar: tarefas críticas não concluídas"
- [ ] Log simples de transições (tabela `episode_status_history` ou log em `episode_notes`)

**Guardrails:**
- ✅ Transições permitidas explícitas (evita pulo de etapa)
- ✅ Mensagens de bloqueio claras (UX melhor)
- ✅ Logs básicos (rastreabilidade)

**Essas duas features dão cara de produto sem custo alto.**

## 5) Governança e segurança (mínimo necessário)

### Segurança — A IMPLEMENTAR

**Autenticação:**
- [ ] Laravel Breeze ou Sanctum (recomendado: Breeze para MVP rápido)
- [ ] Password hash já gerenciado pelo Laravel (`password` → `hashed` cast)
- [ ] Sessões configuradas (já em `database` no `.env`)

**Proteção:**
- [ ] CSRF token em todos os formulários (Laravel já fornece `@csrf`)
- [ ] Validação server-side com Form Requests:
  - [ ] `StoreEpisodeRequest`
  - [ ] `UpdateEpisodeRequest`
  - [ ] `StoreGuestRequest`
  - [ ] `StoreThemeRequest`
  - [ ] Validação de URLs (YouTube, Spotify, LinkedIn, etc.)

**RBAC simples:**
- [ ] Middleware `CheckRole`:
  - [ ] `admin`: acesso total (incluindo gerenciar usuários)
  - [ ] `editor`: sem gerenciar usuários, resto igual
- [ ] Políticas (Policies) do Laravel:
  - [ ] `UserPolicy` (apenas admin pode criar/editar/deletar usuários)
  - [ ] `EpisodePolicy` (todos podem criar/editar, apenas admin deleta)

## 6) Relatórios rápidos (ganho de gestão)

### Relatórios — O "Wow" Barato

**Foco inicial (2 relatórios primeiro):**

- [ ] **Temas mais recorrentes** (top 10 com contagem)
  - Query: `SELECT theme_id, COUNT(*) as count FROM episode_themes GROUP BY theme_id ORDER BY count DESC LIMIT 10`
  - View: tabela simples com nome do tema + contagem
  - **Por quê:** argumento institucional e editorial sem BI

- [ ] **Tempo médio gravação → publicação** (quando existir)
  - Query: `SELECT AVG(DATEDIFF(publish_date, record_date)) as avg_days FROM episodes WHERE publish_date IS NOT NULL AND record_date IS NOT NULL`
  - View: card com número grande + label
  - **Por quê:** métrica de eficiência editorial

**Implementação:**
- [ ] Controller `ReportController` com métodos:
  - [ ] `topThemes()` — top 10 temas
  - [ ] `averagePublishTime()` — tempo médio
- [ ] View simples com cards/tabelas
- [ ] Queries otimizadas com `with()` para evitar N+1

**Relatórios futuros (Sprint 4+):**
- [ ] Episódios por status
- [ ] Convidados mais frequentes
- [ ] Episódios por mês/ano
- [ ] Taxa de conclusão de tarefas

**Isso vira munição editorial e institucional.**

---

## Definições de UI/UX

### Padrões de Interface

**Status (Labels/Badges):**
- [ ] Criar componente Blade `@statusPill($status)` com cores:
  - `pauta`: cinza
  - `gravacao`: azul
  - `edicao`: amarelo
  - `revisao`: laranja
  - `agendado`: roxo
  - `publicado`: verde
- [ ] Usar em cards, listas e detalhes

**Estrutura da tela de Episódio:**
- [ ] **Aba ou bloco:** Convidados e Temas (multi-select na mesma seção)
- [ ] **Aba ou bloco:** Checklist de tarefas (lista com toggle)
- [ ] **Aba ou bloco:** Assets (form + lista)
- [ ] **Botão destacado:** "Avançar Status" (com validação visual)

**Card do Episódio (lista):**
- [ ] Título (link para detalhes)
- [ ] Status (badge colorido)
- [ ] Convidados (chips/nomes, truncado se muitos)
- [ ] Data de publicação (ou gravação se não publicado)
- [ ] Ações rápidas (editar, ver detalhes)

**Navegação:**
- [ ] Sidebar com seções: Dashboard, Episódios, Convidados, Temas, Organizações, Relatórios
- [ ] Breadcrumbs nas páginas internas
- [ ] Botão "Novo Episódio" sempre visível (floating ou header)

---

## Índices e Performance Mínima

### Índices de Banco de Dados

**Já criados implicitamente pelo Laravel:**
- ✅ `episodes.slug` (UNIQUE)
- ✅ Foreign keys (criam índices automaticamente)

**Índices adicionais recomendados (migration):**
- ✅ `episodes.record_date` (para calendário) — **IMPLEMENTADO**
- ✅ `episodes.publish_date` (para calendário e ordenação) — **IMPLEMENTADO**
- ✅ `episode_tasks.due_date` (para calendário) — **IMPLEMENTADO**
- [ ] `episodes.status` (para filtros e relatórios)
- [ ] `episode_guests.guest_id` (para queries de convidados)
- [ ] `episode_themes.theme_id` (para queries de temas)
- [ ] `episodes.created_at` (para listagem recente)

**Criar migration de índices:**
```php
Schema::table('episodes', function (Blueprint $table) {
    $table->index('status');
    $table->index('publish_date');
    $table->index('created_at');
});

Schema::table('episode_guests', function (Blueprint $table) {
    $table->index('guest_id');
});

Schema::table('episode_themes', function (Blueprint $table) {
    $table->index('theme_id');
});
```

**Performance mínima esperada:**
- Listagem de episódios: < 200ms (com paginação)
- Filtros por status/tema: < 300ms
- Relatórios: < 500ms
- Evitar N+1 queries (sempre usar `with()`)

---

## Sprint sugerido (bem executável)

### ✅ Sprint 1 — Fundação (Infra & Data) — CONCLUÍDO

- ✅ Schema completo (migrations)
- ✅ Models com relacionamentos
- ✅ Ambiente Docker funcionando
- ✅ Estrutura de banco de dados completa

**Status:** Infraestrutura e camada de dados 100% prontas.

---

### ⏳ Sprint 1.1 — Fundação (Acesso & UI Base) — EM ANDAMENTO

- ⏳ Seeds (usuário admin + temas iniciais)
- ⏳ Login + layout base
- ⏳ Dashboard simples
- ⏳ CRUD episódios básico (sem N:N ainda)

**Próxima ação imediata:**
1. Criar seeders (`UserSeeder`, `ThemeSeeder`)
2. Instalar Laravel Breeze para autenticação
3. Criar layout base (Blade components)
4. Implementar `EpisodeController` básico

---

### Sprint 2 — Inteligência editorial — EM ANDAMENTO

- ✅ Estrutura de dados pronta (guests, themes, N:N)
- ✅ Datas estruturais prontas (`record_date`, `publish_date`, `due_date`)
- ✅ **Calendário backend** (Service, Controller, DTO, rotas, índices) — **IMPLEMENTADO**
- ⏳ CRUD Convidados
- ⏳ CRUD Temas
- ⏳ N:N: episode_guests e episode_themes (já nos models)
- ⏳ Filtros por tema/convidado na lista de episódios
- ⏳ CRUD Episódios com N:N integrado
- ⏳ **Calendário frontend** (view mensal do calendário)

**Ações esperadas:**
1. `GuestController` com CRUD completo
2. `ThemeController` com CRUD completo
3. Atualizar `EpisodeController` para incluir relacionamentos N:N (`sync()`)
4. Implementar multi-select de convidados e temas no formulário de episódio
5. Adicionar filtros na listagem de episódios
6. **Calendário:** ✅ **IMPLEMENTADO**
   - ✅ Criar `CalendarService` (agrega eventos de `episodes` e `episode_tasks`)
   - ✅ Criar DTO `CalendarEvent`
   - ✅ Criar `CalendarController` com endpoint JSON
   - ✅ Adicionar índices em `record_date`, `publish_date`, `due_date`
   - ⏳ View mensal do calendário (frontend)
7. **Foco:** Sistema vira "memória editorial" e "orquestrador de ritmo" neste sprint

---

### Sprint 3 — Operação de verdade — PLANEJADO

- ⏳ Checklist (tasks) + toggle
- ⏳ Assets (add/remove links)
- ⏳ Regras mínimas de avanço de status
- ⏳ Checklist padrão automático ao criar episódio

**Checklist (Tasks) — Implementação Simples:**

- [ ] Na tela do episódio: lista de tasks com toggle `is_done`
- [ ] Endpoint: `PATCH /episodes/{episode}/tasks/{task}` (route model binding)
- [ ] HTMX/AJAX (ou fetch) para atualizar sem recarregar (padrão "produtividade")
- [ ] Feedback visual imediato (checkbox animado, toast de sucesso)

**Assets — Implementação Simples:**

- [ ] Form simples: tipo (select) + label (input) + URL (input)
- [ ] Lista abaixo com delete (botão com confirmação)
- [ ] Validação de URL no backend
- [ ] Feedback visual ao adicionar/remover

**Ações esperadas:**
1. `EpisodeTaskController` para gerenciar tarefas
2. `EpisodeAssetController` para gerenciar assets
3. Implementar toggle de `is_done` nas tarefas (AJAX/HTMX)
4. Criar `EpisodeStatusService` com máquina de estados formalizada
5. Implementar `EpisodeObserver` para criar tarefas padrão (template)

---

### Sprint 4 — Refinamento — PLANEJADO

- ⏳ Busca (episódios, convidados, temas)
- ⏳ Relatórios básicos
- ⏳ Hardening de segurança
- ⏳ Deploy

**Ações esperadas:**
1. Implementar busca com Laravel Scout ou query simples
2. Criar `ReportController` com queries de relatórios
3. Adicionar validações extras e sanitização
4. Configurar ambiente de produção
5. Deploy em servidor (VPS/Cloud)

---

## Próximo Sprint Real (O que fazer amanhã cedo)

### Ordem de execução para destravar valor rápido:

**Passo 1 — Seeders (fundação de ambiente) — 30 min**
```bash
php artisan make:seeder UserSeeder
php artisan make:seeder ThemeSeeder
php artisan make:seeder OrganizationSeeder  # opcional
```
- [ ] `UserSeeder`: criar usuário admin padrão
- [ ] `ThemeSeeder`: popular top 10 temas iniciais (GovTech, Smart Cities, Ecossistemas de Inovação, etc.)
- [ ] (Opcional) `OrganizationSeeder`: se quiser já ter dropdown bonito

**Passo 2 — Auth com Breeze (Blade) — 1-2h**
```bash
composer require laravel/breeze --dev
php artisan breeze:install blade
```
- [ ] Breeze + middleware auth
- [ ] Gate/Policy ou middleware `CheckRole`
- [ ] Testar login/logout

**Passo 3 — Layout base + navegação — 2h**
- [ ] Sidebar/topbar com links: Dashboard, Episódios, Convidados, Temas, Organizações
- [ ] Um "status pill" padrão (badge) no Blade component
- [ ] Layout responsivo básico

**Passo 4 — CRUD Episódios + N:N logo (não vale adiar) — 3-4h**
- [ ] Episódio create/edit com multi-select convidados e temas
- [ ] Salvar com `sync()` no controller
- [ ] Listar com `with(['guests','themes'])` para evitar N+1
- [ ] **Aqui o sistema já vira "memória editorial", não só cadastro.**

---

## Minha recomendação estratégica

**Comece com Guests + Themes + N:N logo no Sprint 2.** Isso é o que transforma o projeto de "lista de episódios" para "memória editorial do ecossistema". E isso, pro Vale do Pinhão, vale ouro.

**Ordem sugerida de implementação (revisada):**
1. ✅ Seeders → Autenticação → Layout base
2. ⏳ CRUD Episódios **COM N:N** (não adiar — é o diferencial)
3. ⏳ CRUD Convidados + Temas
4. ⏳ Checklist + Assets
5. ⏳ Workflow de status (máquina de estados)
6. ⏳ Relatórios (2 primeiros: temas recorrentes + tempo médio)

**Por quê N:N logo no início:** É isso que transforma o projeto de "lista de episódios" para "memória editorial do ecossistema". E isso, pro Vale do Pinhão, vale ouro.

---

## 📊 Resumo: O que falta fazer

### ✅ Já Implementado (Backend)

**Infraestrutura:**
- ✅ Docker + Laravel 12 + MySQL
- ✅ Todas as migrations (11 tabelas)
- ✅ Todos os models com relacionamentos
- ✅ Índices de calendário (`record_date`, `publish_date`, `due_date`)

**Calendário:**
- ✅ `CalendarService` (agregação de eventos)
- ✅ `CalendarEvent` DTO
- ✅ `CalendarController` (endpoint JSON)
- ✅ Rota `/calendar` registrada

### ⏳ Próximas Prioridades (Ordem de Execução)

**Sprint 1.1 — Fundação (Acesso & UI Base):**

1. **Seeders** (30 min) — **CRÍTICO**
   - [ ] `UserSeeder` — usuário admin padrão
   - [ ] `ThemeSeeder` — temas iniciais
   - [ ] Rodar `php artisan db:seed`

2. **Autenticação** (1-2h) — **CRÍTICO**
   - [ ] Instalar Laravel Breeze
   - [ ] Configurar login/logout
   - [ ] Middleware `CheckRole` (admin/editor)
   - [ ] Proteger rotas existentes

3. **Layout Base** (2h) — **CRÍTICO**
   - [ ] Sidebar/navegação
   - [ ] Componente `@statusPill($status)`
   - [ ] Layout responsivo básico

4. **CRUD Episódios Básico** (3-4h) — **ALTA PRIORIDADE**
   - [ ] `EpisodeController` (resource)
   - [ ] Form Requests (`StoreEpisodeRequest`, `UpdateEpisodeRequest`)
   - [ ] Views: index, create, edit, show
   - [ ] Listagem com paginação

**Sprint 2 — Inteligência Editorial:**

5. **CRUD Episódios com N:N** (2-3h) — **ALTA PRIORIDADE**
   - [ ] Multi-select de convidados no formulário
   - [ ] Multi-select de temas no formulário
   - [ ] Salvar com `sync()` no controller
   - [ ] Listar com `with(['guests','themes'])`

6. **CRUD Convidados** (1-2h)
   - [ ] `GuestController` (resource)
   - [ ] Views básicas
   - [ ] Validações

7. **CRUD Temas** (1-2h)
   - [ ] `ThemeController` (resource)
   - [ ] Views básicas
   - [ ] Validações

8. **Calendário Frontend** (2-3h)
   - [ ] View mensal do calendário
   - [ ] Integração com endpoint `/calendar`
   - [ ] Cores por tipo de evento
   - [ ] Click leva para episódio

9. **Filtros** (1-2h)
   - [ ] Filtro por status na lista de episódios
   - [ ] Filtro por tema
   - [ ] Filtro por convidado

**Sprint 3 — Operação:**

10. **Checklist de Tarefas** (2-3h)
    - [ ] `EpisodeTaskController`
    - [ ] Toggle `is_done` (AJAX/HTMX)
    - [ ] Lista na tela do episódio
    - [ ] `EpisodeObserver` para criar tarefas padrão

11. **Assets** (1-2h)
    - [ ] `EpisodeAssetController`
    - [ ] Form + lista na tela do episódio
    - [ ] Validação de URLs

12. **Workflow de Status** (2-3h)
    - [ ] `EpisodeStatusService` (máquina de estados)
    - [ ] Botão "Avançar Status"
    - [ ] Validações e mensagens de bloqueio

**Sprint 4 — Refinamento:**

13. **Dashboard** (2h)
    - [ ] Cards por status
    - [ ] Lista de episódios recentes
    - [ ] Estatísticas rápidas

14. **Relatórios** (2-3h)
    - [ ] `ReportController`
    - [ ] Top 10 temas
    - [ ] Tempo médio gravação → publicação

15. **Busca** (1-2h)
    - [ ] Busca simples (episódios, convidados, temas)
    - [ ] Query otimizada

16. **Índices Restantes** (30 min)
    - [ ] `episodes.status`
    - [ ] `episode_guests.guest_id`
    - [ ] `episode_themes.theme_id`
    - [ ] `episodes.created_at`

### 🎯 Foco Imediato (Próximas 2-3 horas)

**Para destravar o sistema:**

1. **Seeders** → dados iniciais para testar
2. **Autenticação** → proteger o sistema
3. **Layout base** → estrutura visual
4. **CRUD Episódios básico** → primeira funcionalidade completa

**Depois disso, o sistema já tem valor operacional básico.**