# 🎨 Banners do Formulário

## 📁 Localização

Os banners devem ser colocados em:
```
backend/public/images/banners/
```

## 📐 Tamanhos Recomendados

### ✅ Opção Recomendada: Banner Único Responsivo

**Tamanho:** `1920 x 600px`
- **Proporção:** 16:5 (3.2:1)
- **Formato:** JPG, PNG ou WebP
- **Peso máximo:** 300KB (otimizado)
- **Vantagem:** Uma única imagem que se adapta automaticamente

### 📱 Opção Alternativa: Múltiplos Tamanhos

Se quiser otimizar ainda mais a performance:

| Dispositivo | Tamanho | Proporção | Peso |
|-------------|---------|-----------|------|
| **Desktop** | 1920 x 600px | 16:5 | ~200-300KB |
| **Tablet** | 1200 x 400px | 3:1 | ~150-200KB |
| **Mobile** | 800 x 300px | 8:3 | ~100-150KB |

## 🎯 Especificações Técnicas

### Formatos Suportados
1. **WebP** (recomendado) - Melhor compressão
2. **JPG** - Boa para fotos
3. **PNG** - Use apenas se precisar transparência

### Qualidade
- **JPG:** 80-85%
- **WebP:** 80-90%
- **PNG:** Use apenas se necessário

### Otimização
- Sempre otimize antes de fazer upload
- Ferramentas recomendadas:
  - [TinyPNG](https://tinypng.com/)
  - [Squoosh](https://squoosh.app/)
  - [ImageOptim](https://imageoptim.com/)

## 📝 Convenção de Nomenclatura

O sistema procura por estes nomes (nesta ordem):
1. `banner-formulario.webp` (prioridade)
2. `banner-formulario.jpg`
3. `banner-formulario.png`

**Importante:** Use apenas um arquivo. O sistema escolhe automaticamente o melhor formato disponível.

## 🎨 Área Segura

Mantenha conteúdo importante dentro de:
- **Desktop:** Centro 1400px
- **Tablet:** Centro 900px  
- **Mobile:** Centro 600px

Isso garante que textos e elementos importantes não sejam cortados em diferentes telas.

## 📱 Comportamento Responsivo

O banner se adapta automaticamente:
- **Largura:** 100% do container (com padding lateral)
- **Altura:** Automática (mantém proporção)
- **Object-fit:** `cover` (cobre toda a área)

## 🔄 Como Adicionar/Atualizar Banner

1. **Prepare a imagem:**
   - Tamanho: 1920 x 600px
   - Formato: WebP, JPG ou PNG
   - Otimizada: < 300KB

2. **Salve na pasta:**
   ```
   backend/public/images/banners/banner-formulario.jpg
   ```
   (ou .webp, .png)

3. **Limpe o cache (opcional):**
   ```bash
   cd docker
   docker-compose exec app php artisan view:clear
   ```

4. **Pronto!** O banner aparecerá automaticamente no topo do formulário.

## ⚠️ Dicas Importantes

### ✅ Faça
- Use imagens otimizadas para web
- Mantenha textos legíveis em todos os tamanhos
- Teste em diferentes dispositivos
- Use área segura para conteúdo importante

### ❌ Evite
- Imagens muito pesadas (> 500KB)
- Textos nas bordas (podem ser cortados)
- Formato GIF (muito pesado)
- Imagens não otimizadas

## 🎯 Exemplo de Uso

### Estrutura de Arquivos
```
backend/
  public/
    images/
      banners/
        banner-formulario.jpg  ← Coloque aqui
        README.md
```

### No Formulário
O banner aparece automaticamente entre o header e o formulário, se o arquivo existir.

## 🔍 Verificação

Para verificar se o banner está funcionando:
1. Acesse: `http://localhost:8080/manifestar-interesse`
2. O banner deve aparecer logo após o título
3. Se não aparecer, verifique:
   - Arquivo existe na pasta correta?
   - Nome do arquivo está correto?
   - Cache foi limpo?

## 📊 Performance

### Boas Práticas
- **Tamanho máximo:** 300KB
- **Lazy loading:** Ativado automaticamente
- **Formato WebP:** Reduz ~30% do tamanho vs JPG
- **Otimização:** Sempre comprima antes de usar

### Impacto
- Banner otimizado: ~200-300KB
- Tempo de carregamento: < 1s (em conexão boa)
- Impacto no SEO: Positivo (conteúdo visual)

---

## 🚀 Próximos Passos

1. Crie o banner no tamanho recomendado (1920 x 600px)
2. Otimize a imagem
3. Salve como `banner-formulario.jpg` (ou .webp, .png)
4. Coloque na pasta `backend/public/images/banners/`
5. Teste no navegador!
